"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ldflex = require("ldflex");

var _dataModel = require("@rdfjs/data-model");

var _context = _interopRequireDefault(require("./context.json"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _awaitAsyncGenerator(value) { return new _AwaitValue(value); }

function _wrapAsyncGenerator(fn) { return function () { return new _AsyncGenerator(fn.apply(this, arguments)); }; }

function _AsyncGenerator(gen) { var front, back; function send(key, arg) { return new Promise(function (resolve, reject) { var request = { key: key, arg: arg, resolve: resolve, reject: reject, next: null }; if (back) { back = back.next = request; } else { front = back = request; resume(key, arg); } }); } function resume(key, arg) { try { var result = gen[key](arg); var value = result.value; var wrappedAwait = value instanceof _AwaitValue; Promise.resolve(wrappedAwait ? value.wrapped : value).then(function (arg) { if (wrappedAwait) { resume("next", arg); return; } settle(result.done ? "return" : "normal", arg); }, function (err) { resume("throw", err); }); } catch (err) { settle("throw", err); } } function settle(type, value) { switch (type) { case "return": front.resolve({ value: value, done: true }); break; case "throw": front.reject(value); break; default: front.resolve({ value: value, done: false }); break; } front = front.next; if (front) { resume(front.key, front.arg); } else { back = null; } } this._invoke = send; if (typeof gen.return !== "function") { this.return = undefined; } }

if (typeof Symbol === "function" && Symbol.asyncIterator) { _AsyncGenerator.prototype[Symbol.asyncIterator] = function () { return this; }; }

_AsyncGenerator.prototype.next = function (arg) { return this._invoke("next", arg); };

_AsyncGenerator.prototype.throw = function (arg) { return this._invoke("throw", arg); };

_AsyncGenerator.prototype.return = function (arg) { return this._invoke("return", arg); };

function _AwaitValue(value) { this.wrapped = value; }

function _asyncIterator(iterable) { var method; if (typeof Symbol === "function") { if (Symbol.asyncIterator) { method = iterable[Symbol.asyncIterator]; if (method != null) return method.call(iterable); } if (Symbol.iterator) { method = iterable[Symbol.iterator]; if (method != null) return method.call(iterable); } } throw new TypeError("Object is not async iterable"); }

const as = _context.default['@context'].as;
/**
 * Base class for handlers that manipulate activities
 * Requires:
 * - the `root.user` handler
 * - the `root[...]` resolver
 * - a queryEngine property in the path settings
 */

class ActivityHandler {
  constructor() {
    let _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref2$activitiesPath = _ref2.activitiesPath,
        activitiesPath = _ref2$activitiesPath === void 0 ? '/public/activities' : _ref2$activitiesPath;

    _defineProperty(this, "requireUser", true);

    this.activitiesPath = activitiesPath;
  }

  handle(pathData, path) {
    const self = this;
    const root = path.root;
    const queryEngine = pathData.settings.queryEngine; // Return an iterator over the activity paths

    return function () {
      let type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : `${as}Like`;
      return (0, _ldflex.toIterablePromise)(
      /*#__PURE__*/
      _wrapAsyncGenerator(function* () {
        // Only process activities if a user is logged in
        let user;

        try {
          user = yield _awaitAsyncGenerator(root.user);
        } catch (error) {
          if (self.requireUser) throw error;
          return;
        } // Determine the storage location


        const storage = yield _awaitAsyncGenerator(root.user.pim$storage);
        const document = new URL(self.activitiesPath, storage || user).href; // Obtain results for every activity on the path

        const results = [];
        const actor = (0, _dataModel.namedNode)(user);
        type = (0, _dataModel.namedNode)(type);
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;

        var _iteratorError;

        try {
          for (var _iterator = _asyncIterator(path), _step, _value; _step = yield _awaitAsyncGenerator(_iterator.next()), _iteratorNormalCompletion = _step.done, _value = yield _awaitAsyncGenerator(_step.value), !_iteratorNormalCompletion; _iteratorNormalCompletion = true) {
            const object = _value;

            if (object.termType === 'NamedNode') {
              const activity = {
                actor,
                type,
                object
              };
              var _iteratorNormalCompletion2 = true;
              var _didIteratorError2 = false;

              var _iteratorError2;

              try {
                for (var _iterator2 = _asyncIterator(self.createResults(activity, document, queryEngine)), _step2, _value2; _step2 = yield _awaitAsyncGenerator(_iterator2.next()), _iteratorNormalCompletion2 = _step2.done, _value2 = yield _awaitAsyncGenerator(_step2.value), !_iteratorNormalCompletion2; _iteratorNormalCompletion2 = true) {
                  const result = _value2;
                  results.push(result);
                }
              } catch (err) {
                _didIteratorError2 = true;
                _iteratorError2 = err;
              } finally {
                try {
                  if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
                    yield _awaitAsyncGenerator(_iterator2.return());
                  }
                } finally {
                  if (_didIteratorError2) {
                    throw _iteratorError2;
                  }
                }
              }
            }
          } // Process all results and return paths starting from the returned terms

        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return != null) {
              yield _awaitAsyncGenerator(_iterator.return());
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }

        for (const term of yield _awaitAsyncGenerator(self.processResults(results, document, queryEngine))) yield root[term.value];
      }));
    };
  }

  async processResults(results) {
    return results;
  }

}

exports.default = ActivityHandler;