"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ldflexComunica = _interopRequireDefault(require("ldflex-comunica"));

var _solidAuthClient = _interopRequireDefault(require("solid-auth-client"));

var _util = require("./util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * An extension of ComunicaEngine that delegates
 * SPARQL UPDATE queries directly to the documents
 * using authenticated request.
 */
class ComunicaUpdateEngine extends _ldflexComunica.default {
  /**
   * Executes a SPARQL UPDATE query on the source.
   */
  executeUpdate(sparql, source) {
    let done = false;

    const next = async () => {
      if (done) return {
        done
      };
      done = true; // Find the document to update

      const sources = await (source ? this.toComunicaSources(source) : this._sources);
      if (!sources || sources.length !== 1) throw new Error('Can only update a single source.');

      const _sources = _slicedToArray(sources, 1),
            document = _sources[0].value;

      if (!/^https?:\/\//.test(document)) throw new Error('Can only update an HTTP(s) document.'); // Send authenticated PATCH request to the document

      const _ref = await _solidAuthClient.default.fetch(document, {
        method: 'PATCH',
        headers: {
          'Content-Type': 'application/sparql-update'
        },
        body: sparql
      }),
            ok = _ref.ok,
            status = _ref.status,
            statusText = _ref.statusText; // Error if the server response was not ok


      if (!ok) throw new Error(`Update query failed (${status}): ${statusText}`); // Clear stale cached versions of the document

      await this.clearCache(document);
      return {
        value: (0, _util.createBindings)({
          ok
        })
      };
    };

    return {
      next,

      [Symbol.asyncIterator]() {
        return this;
      }

    };
  }
  /**
   * Removes the given document (or all, if not specified) from the query engine cache,
   * such that fresh results are obtained the next time.
   */


  async clearCache(document) {
    await this._engine.invalidateHttpCache(document);
  }

}

exports.default = ComunicaUpdateEngine;