"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ldflex = require("ldflex");

function _asyncIterator(iterable) { var method; if (typeof Symbol === "function") { if (Symbol.asyncIterator) { method = iterable[Symbol.asyncIterator]; if (method != null) return method.call(iterable); } if (Symbol.iterator) { method = iterable[Symbol.iterator]; if (method != null) return method.call(iterable); } } throw new TypeError("Object is not async iterable"); }

/**
 * node-solid-server deviates from the SPARQL UPDATE spec:
 * whereas the spec asks for DELETE on non-existing triples to silently succeed,
 * node-solid-server will only DELETE if exactly one triple matches.
 *
 * This delete handler works around that limitation
 * by first requesting all existing values for a path,
 * and then only issuing DELETE statements for those that exist.
 */
class SolidDeleteFunctionHandler extends _ldflex.DeleteFunctionHandler {
  async extractObjects(pathData, path, args) {
    // Obtain all values whose deletion was requested
    const objects = await super.extractObjects(pathData, path, args); // Obtain all values that currently exist

    const existing = [];
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;

    var _iteratorError;

    try {
      for (var _iterator = _asyncIterator(path), _step, _value; _step = await _iterator.next(), _iteratorNormalCompletion = _step.done, _value = await _step.value, !_iteratorNormalCompletion; _iteratorNormalCompletion = true) {
        const term = _value;
        if (term.termType !== 'BlankNode') existing.push(term);
      } // Perform deletions only for values that exist

    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          await _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return !objects ? existing : existing.filter(e => objects.some(o => o.equals(e)));
  }

}

exports.default = SolidDeleteFunctionHandler;