"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ldflex = require("ldflex");

var _dataModel = require("@rdfjs/data-model");

/**
 * node-solid-server does not support multiple INSERT clauses,
 * so this handler only generates only one.
 */
class SolidInsertFunctionHandler extends _ldflex.InsertFunctionHandler {
  async createRangeExpressions(pathData, path, args) {
    // Gather all values whose addition was requested
    const values = await Promise.all(args.map(async rawValue => {
      const value = await rawValue; // Strings indicate literals

      if (typeof value === 'string') return (0, _dataModel.literal)(value); // Only literals and named nodes are supported

      const termType = value && value.termType;
      if (termType === 'literal' || termType === 'namedNode') return value;
      throw new Error(`Unsupported argument: ${value}`);
    }));
    return [[{
      subject: values
    }]];
  }

}

exports.default = SolidInsertFunctionHandler;