"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ldflex = require("ldflex");

var _SubjectPathResolver = _interopRequireDefault(require("./SubjectPathResolver"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class SourcePathHandler {
  constructor(pathFactory) {
    this._paths = pathFactory;
  }

  handle() {
    return source => this._createSourcePathFactory(source);
  }

  _createSourcePathFactory(source) {
    return new _ldflex.PathFactory({
      handlers: _objectSpread({}, _ldflex.defaultHandlers),
      resolvers: [new _SubjectPathResolver.default(this._paths, source)]
    }).create();
  }

}

exports.default = SourcePathHandler;