"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _SubjectPathResolver = _interopRequireDefault(require("./SubjectPathResolver"));

var _solidAuthClient = _interopRequireDefault(require("solid-auth-client"));

var _dataModel = require("@rdfjs/data-model");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Creates a path with the current user as a subject.
 */
class UserPathHandler extends _SubjectPathResolver.default {
  handle() {
    const subject = this.getWebId().then(_dataModel.namedNode);
    return this._createSubjectPath(subject);
  }
  /** Gets the WebID of the logged in user */


  async getWebId() {
    const session = await _solidAuthClient.default.currentSession();
    if (!session) throw new Error('Cannot resolve user path: no user logged in');
    return session.webId;
  }

}

exports.default = UserPathHandler;