"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ldflex = require("ldflex");

var _context2 = _interopRequireDefault(require("./context.json"));

var _SolidDeleteFunctionHandler = _interopRequireDefault(require("./SolidDeleteFunctionHandler"));

var _FindActivityHandler = _interopRequireDefault(require("./FindActivityHandler"));

var _CreateActivityHandler = _interopRequireDefault(require("./CreateActivityHandler"));

var _DeleteActivityHandler = _interopRequireDefault(require("./DeleteActivityHandler"));

var _SourcePathHandler = _interopRequireDefault(require("./SourcePathHandler"));

var _UserPathHandler = _interopRequireDefault(require("./UserPathHandler"));

var _SubjectPathResolver = _interopRequireDefault(require("./SubjectPathResolver"));

var _ComunicaUpdateEngine = _interopRequireDefault(require("./ComunicaUpdateEngine"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const _context = _context2.default['@context'];
const as = _context.as;
let rootPath; // Creates data paths that start from a given subject

const subjectPathFactory = new _ldflex.PathFactory({
  context: _context,
  handlers: _objectSpread({}, _ldflex.defaultHandlers, {
    // Custom delete handler to match node-solid-server behavior
    delete: new _SolidDeleteFunctionHandler.default(),
    // Find activities
    findActivity: new _FindActivityHandler.default(),
    likes: (_, path) => path.findActivity(`${as}Like`),
    dislikes: (_, path) => path.findActivity(`${as}Dislike`),
    follows: (_, path) => path.findActivity(`${as}Follow`),
    // Create activities
    createActivity: new _CreateActivityHandler.default(),
    like: (_, path) => () => path.createActivity(`${as}Like`),
    dislike: (_, path) => () => path.createActivity(`${as}Dislike`),
    follow: (_, path) => () => path.createActivity(`${as}Follow`),
    // Delete activities
    deleteActivity: new _DeleteActivityHandler.default(),
    unlike: (_, path) => () => path.deleteActivity(`${as}Like`),
    undislike: (_, path) => () => path.deleteActivity(`${as}Dislike`),
    unfollow: (_, path) => () => path.deleteActivity(`${as}Follow`),
    // The `root` property restarts the path from the root
    root: () => rootPath
  })
}); // Export the root path that resolves the first property access

var _default = rootPath = new _ldflex.PathFactory({
  // Handlers of specific named properties
  handlers: _objectSpread({}, _ldflex.defaultHandlers, {
    // The `from` property takes a source URI as input
    from: new _SourcePathHandler.default(subjectPathFactory),
    // The `user` property starts a path with the current user as subject
    user: new _UserPathHandler.default(subjectPathFactory),
    // Clears the cache for the given document (or everything, if undefined)
    clearCache: (_ref) => {
      let settings = _ref.settings;
      return doc => settings.queryEngine.clearCache(doc);
    },
    // Expose the JSON-LD context
    context: () => _context
  }),
  // Handlers of all remaining properties
  resolvers: [// `data[url]` starts a path with the property as subject
  new _SubjectPathResolver.default(subjectPathFactory)],
  // Global query engine (currently only used for clearing the cache)
  queryEngine: new _ComunicaUpdateEngine.default()
}).create();

exports.default = _default;