"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceVariables = replaceVariables;
exports.serializeTerm = serializeTerm;
exports.createBindings = createBindings;

function replaceVariables(template, terms) {
  for (const name in terms) template = template.replace(new RegExp(`_:${name}`, 'g'), serializeTerm(terms[name]));

  return template;
}

function serializeTerm(term) {
  switch (term.termType) {
    case 'NamedNode':
      return `<${term.value}>`;

    case 'Literal':
      // TODO: escaping
      return `"${term.value}"^^<${term.datatype.value}>`;
    // TODO: other types

    default:
      throw new Error(`Unknown term type: ${term.termType}`);
  }
} // Imitate Comunica's response for bindings as a Immutable.js object.


function createBindings() {
  for (var _len = arguments.length, items = new Array(_len), _key = 0; _key < _len; _key++) {
    items[_key] = arguments[_key];
  }

  return {
    size: items.length,
    values: () => ({
      next: () => ({
        value: items.shift()
      })
    })
  };
}