"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.default = ActivityButton;
exports.customActivityButton = customActivityButton;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _react = _interopRequireWildcard(require("react"));

var _queryLdflex = _interopRequireDefault(require("@solid/query-ldflex"));

var _util = require("../util");

var _useLDflexValue = _interopRequireDefault(require("../hooks/useLDflexValue"));

const as = _queryLdflex.default.context.as;
/**
 * Button that displays whether the user has performed an activity;
 * when clicked, performs the activity.
 */

function ActivityButton(_ref) {
  let _ref$activityType = _ref.activityType,
      activityType = _ref$activityType === void 0 ? `${as}Like` : _ref$activityType,
      _ref$object = _ref.object,
      object = _ref$object === void 0 ? `[${window.location.href}]` : _ref$object,
      children = _ref.children,
      _ref$shortName = _ref.shortName,
      shortName = _ref$shortName === void 0 ? /\w*$/.exec(activityType)[0] : _ref$shortName,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? `solid activity ${shortName.toLowerCase()}` : _ref$className,
      _ref$activateText = _ref.activateText,
      activateText = _ref$activateText === void 0 ? shortName : _ref$activateText,
      _ref$deactivateText = _ref.deactivateText,
      deactivateText = _ref$deactivateText === void 0 ? activateText : _ref$deactivateText,
      _ref$activateLabel = _ref.activateLabel,
      activateLabel = _ref$activateLabel === void 0 ? children ? [activateText, ' ', children] : activateText : _ref$activateLabel,
      _ref$deactivateLabel = _ref.deactivateLabel,
      deactivateLabel = _ref$deactivateLabel === void 0 ? children ? [deactivateText, ' ', children] : deactivateText : _ref$deactivateLabel,
      props = (0, _objectWithoutPropertiesLoose2.default)(_ref, ["activityType", "object", "children", "shortName", "className", "activateText", "deactivateText", "activateLabel", "deactivateLabel"]);
  // Look up a possibly existing activity
  object = (0, _util.srcToLDflex)(object);

  const _useState = (0, _react.useState)(),
        exists = _useState[0],
        setExists = _useState[1];

  const activity = (0, _useLDflexValue.default)(`${object}.findActivity("${activityType}")`);
  if (exists === undefined && activity) setExists(true); // Creates a new activity (if none already exists)

  async function toggleActivity() {
    // Optimistically display the result
    setExists(!exists);

    try {
      // Try performing the action
      const action = !exists ? 'create' : 'delete';
      await _queryLdflex.default.resolve(`${object}.${action}Activity("${activityType}")`); // Confirm the result (in case a concurrent action was pending)

      setExists(!exists);
    } catch (error) {
      // Revert to the previous state
      setExists(exists);
      console.warn('@solid/react-components', error);
    }
  } // Return the activity button


  className = `${className} ${exists ? 'performed' : ''}`;
  return _react.default.createElement("button", (0, _extends2.default)({
    className: className,
    onClick: toggleActivity
  }, props), exists ? deactivateLabel : activateLabel);
} // Internal helper for creating custom activity buttons


function customActivityButton(type, activate, deactivate, deactivateNoChildren) {
  const activityType = `${as}${type}`;
  return (_ref2) => {
    let object = _ref2.object,
        _ref2$children = _ref2.children,
        children = _ref2$children === void 0 ? object ? null : 'this page' : _ref2$children,
        _ref2$activateText = _ref2.activateText,
        activateText = _ref2$activateText === void 0 ? activate : _ref2$activateText,
        _ref2$deactivateText = _ref2.deactivateText,
        deactivateText = _ref2$deactivateText === void 0 ? children ? deactivate : deactivateNoChildren : _ref2$deactivateText,
        props = (0, _objectWithoutPropertiesLoose2.default)(_ref2, ["object", "children", "activateText", "deactivateText"]);
    return _react.default.createElement(ActivityButton, (0, _extends2.default)({}, props, {
      activityType,
      object,
      children,
      activateText,
      deactivateText
    }));
  };
}