"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.default = AuthButton;

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _react = _interopRequireDefault(require("react"));

var _LoginButton = _interopRequireDefault(require("./LoginButton"));

var _LogoutButton = _interopRequireDefault(require("./LogoutButton"));

var _useLoggedIn = _interopRequireDefault(require("../hooks/useLoggedIn"));

/** Button that lets the user log in or out with Solid.  */
function AuthButton(_ref) {
  let login = _ref.login,
      logout = _ref.logout,
      props = (0, _objectWithoutPropertiesLoose2.default)(_ref, ["login", "logout"]);
  return (0, _useLoggedIn.default)() ? _react.default.createElement(_LogoutButton.default, props, logout) : _react.default.createElement(_LoginButton.default, props, login);
}