"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.default = LoginButton;

var _react = _interopRequireDefault(require("react"));

var _solidAuthClient = _interopRequireDefault(require("solid-auth-client"));

/** Button that lets the user log in with Solid. */
function LoginButton({
  popup,
  children = 'Log in',
  className = 'solid auth login'
}) {
  return _react.default.createElement("button", {
    className: className,
    onClick: () => _solidAuthClient.default.popupLogin({
      popupUri: popup
    })
  }, children);
}