#! /usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const minimist = require("minimist");
const sparqlAlgebra_1 = require("../lib/sparqlAlgebra");
const sparql_1 = require("../lib/sparql");
const util_1 = require("../test/util");
const args = minimist(process.argv.slice(2), {
    boolean: ['q', 'r'],
    alias: { q: 'quads', r: 'reverse' }
});
if (args.h || args.help || args._.length !== 1) {
    console.error('usage: ./sparqlalgebrajs [-q/--quads] "SELECT * WHERE { ?x ?y ?z}"');
    console.error('options:');
    console.error('  -h --help  : Show this output.');
    console.error('  -q --quads : Apply GRAPH statements to convert triples to quads.');
    console.error('  -r --reverse  : Convert algebra to SPARQL.');
    process.exit((args.h || args.help) ? 0 : 1);
}
if (args.r || args.reverse) {
    console.log(sparql_1.toSparql(JSON.parse(args._[0])));
}
else {
    console.log(JSON.stringify(util_1.default.objectify(sparqlAlgebra_1.default(args._[0], { quads: args.q })), null, 2));
}
//# sourceMappingURL=sparqlalgebrajs.js.map