import * as A from './algebra';
import * as RDF from "rdf-js";
export default class Factory {
    dataFactory: RDF.DataFactory;
    stringType: RDF.NamedNode;
    constructor(dataFactory?: RDF.DataFactory);
    createAlt(left: A.PropertyPathSymbol, right: A.PropertyPathSymbol): A.Alt;
    createAsk(input: A.Operation): A.Ask;
    createBoundAggregate(variable: RDF.Variable, aggregate: string, expression: A.Expression, distinct: boolean, separator?: string): A.BoundAggregate;
    createBgp(patterns: A.Pattern[]): A.Bgp;
    createConstruct(input: A.Operation, template: A.Pattern[]): A.Construct;
    createDescribe(input: A.Operation, terms: RDF.Term[]): A.Describe;
    createDistinct(input: A.Operation): A.Distinct;
    createExtend(input: A.Operation, variable: RDF.Variable, expression: A.Expression): A.Extend;
    createFrom(input: A.Operation, def: RDF.Term[], named: RDF.Term[]): A.From;
    createFilter(input: A.Operation, expression: A.Expression): A.Filter;
    createGraph(input: A.Operation, name: RDF.Term): A.Graph;
    createGroup(input: A.Operation, variables: RDF.Variable[], aggregates: A.BoundAggregate[]): A.Group;
    createInv(path: A.PropertyPathSymbol): A.Inv;
    createJoin(left: A.Operation, right: A.Operation): A.Join;
    createLeftJoin(left: A.Operation, right: A.Operation, expression?: A.Expression): A.LeftJoin;
    createLink(iri: RDF.NamedNode): A.Link;
    createMinus(left: A.Operation, right: A.Operation): A.Minus;
    createNps(iris: RDF.NamedNode[]): A.Nps;
    createOneOrMorePath(path: A.PropertyPathSymbol): A.OneOrMorePath;
    createOrderBy(input: A.Operation, expressions: A.Expression[]): A.OrderBy;
    createPath(subject: RDF.Term, predicate: A.PropertyPathSymbol, object: RDF.Term, graph?: RDF.Term): A.Path;
    createPattern(subject: RDF.Term, predicate: RDF.Term, object: RDF.Term, graph?: RDF.Term): A.Pattern;
    createProject(input: A.Operation, variables: RDF.Variable[]): A.Project;
    createReduced(input: A.Operation): A.Reduced;
    createSeq(left: A.PropertyPathSymbol, right: A.PropertyPathSymbol): A.Seq;
    createService(input: A.Operation, name: RDF.Term, silent?: boolean): A.Service;
    createSlice(input: A.Operation, start: number, length?: number): A.Slice;
    createUnion(left: A.Operation, right: A.Operation): A.Union;
    createValues(variables: RDF.Variable[], bindings: {
        [key: string]: RDF.Term;
    }[]): A.Values;
    createZeroOrMorePath(path: A.PropertyPathSymbol): A.ZeroOrMorePath;
    createZeroOrOnePath(path: A.PropertyPathSymbol): A.ZeroOrOnePath;
    createAggregateExpression(aggregator: string, expression: A.Expression, distinct: boolean, separator?: string): A.AggregateExpression;
    createExistenceExpression(not: boolean, input: A.Operation): A.ExistenceExpression;
    createNamedExpression(name: RDF.NamedNode, args: A.Expression[]): A.NamedExpression;
    createOperatorExpression(operator: string, args: A.Expression[]): A.OperatorExpression;
    createTermExpression(term: RDF.Term): A.TermExpression;
    createTerm(str: string): RDF.Term;
}
