"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const DataFactory = require("@rdfjs/data-model");
const rdf_string_1 = require("rdf-string");
class Factory {
    constructor(dataFactory) {
        this.dataFactory = dataFactory || DataFactory;
        this.stringType = this.createTerm('http://www.w3.org/2001/XMLSchema#string');
    }
    createAlt(left, right) { return { type: 'alt', left, right }; }
    createAsk(input) { return { type: 'ask', input }; }
    createBoundAggregate(variable, aggregate, expression, distinct, separator) {
        let result = this.createAggregateExpression(aggregate, expression, distinct, separator);
        result.variable = variable;
        return result;
    }
    createBgp(patterns) { return { type: 'bgp', patterns }; }
    createConstruct(input, template) { return { type: 'construct', input, template }; }
    createDescribe(input, terms) { return { type: 'describe', input, terms }; }
    createDistinct(input) { return { type: 'distinct', input }; }
    createExtend(input, variable, expression) { return { type: 'extend', input, variable, expression }; }
    createFrom(input, def, named) { return { type: 'from', input, default: def, named }; }
    createFilter(input, expression) { return { type: 'filter', input, expression }; }
    createGraph(input, name) { return { type: 'graph', input, name }; }
    createGroup(input, variables, aggregates) { return { type: 'group', input, variables, aggregates }; }
    createInv(path) { return { type: 'inv', path }; }
    createJoin(left, right) { return { type: 'join', left, right }; }
    createLeftJoin(left, right, expression) {
        if (expression)
            return { type: 'leftjoin', left, right, expression };
        return { type: 'leftjoin', left, right };
    }
    createLink(iri) { return { type: 'link', iri }; }
    createMinus(left, right) { return { type: 'minus', left, right }; }
    createNps(iris) { return { type: 'nps', iris }; }
    createOneOrMorePath(path) { return { type: 'OneOrMorePath', path }; }
    createOrderBy(input, expressions) { return { type: 'orderby', input, expressions }; }
    createPath(subject, predicate, object, graph) {
        if (graph)
            return { type: 'path', subject, predicate, object, graph };
        return { type: 'path', subject, predicate, object, graph: this.dataFactory.defaultGraph() };
    }
    createPattern(subject, predicate, object, graph) {
        let pattern;
        if (graph)
            pattern = this.dataFactory.quad(subject, predicate, object, graph);
        else
            pattern = this.dataFactory.triple(subject, predicate, object);
        pattern.type = 'pattern';
        return pattern;
    }
    createProject(input, variables) { return { type: 'project', input, variables }; }
    createReduced(input) { return { type: 'reduced', input }; }
    createSeq(left, right) { return { type: 'seq', left, right }; }
    createService(input, name, silent) { return { type: 'service', input, name, silent }; }
    createSlice(input, start, length) {
        if (start === undefined)
            start = 0;
        if (length !== undefined)
            return { type: 'slice', input, start, length };
        return { type: 'slice', input, start };
    }
    createUnion(left, right) { return { type: 'union', left, right }; }
    createValues(variables, bindings) { return { type: 'values', variables, bindings }; }
    createZeroOrMorePath(path) { return { type: 'ZeroOrMorePath', path }; }
    createZeroOrOnePath(path) { return { type: 'ZeroOrOnePath', path }; }
    createAggregateExpression(aggregator, expression, distinct, separator) {
        if (separator)
            return { type: 'expression', expressionType: 'aggregate', aggregator, expression, separator, distinct };
        return { type: 'expression', expressionType: 'aggregate', aggregator, expression, distinct };
    }
    createExistenceExpression(not, input) { return { type: 'expression', expressionType: 'existence', not, input }; }
    createNamedExpression(name, args) { return { type: 'expression', expressionType: 'named', name, args }; }
    createOperatorExpression(operator, args) { return { type: 'expression', expressionType: 'operator', operator, args }; }
    createTermExpression(term) { return { type: 'expression', expressionType: 'term', term }; }
    createTerm(str) {
        return rdf_string_1.stringToTerm(str, this.dataFactory);
    }
}
exports.default = Factory;
//# sourceMappingURL=factory.js.map