import * as Algebra from './algebra';
import * as RDF from 'rdf-js';
/**
 * Translates the given SPARQL query to SPARQL Algebra.
 * @param sparql - Either a SPARQL string or an object generated by sparql.js
 * @param options - Optional options object. Current options:
 *                    * dataFactory: The Datafactory used to generate terms. Default @rdfjs/data-model.
 *                    * quads: Boolean indicating whether triples should be converted to Quads (consumes GRAPH statements). Default false.
 *                    * prefixes: Pre-defined prefixes for the given query. Default empty.
 *                    * baseIRI: Base IRI that should be used for the query. Default undefined (throws error if required).
 * @returns {Operation}
 */
export default function translate(sparql: any, options?: {
    dataFactory?: RDF.DataFactory;
    quads?: boolean;
    prefixes?: {
        [prefix: string]: string;
    };
    baseIRI?: string;
    blankToVariable?: boolean;
}): Algebra.Operation;
