#! /usr/bin/env node
"use strict";
// tslint:disable:no-console
Object.defineProperty(exports, "__esModule", { value: true });
const sparqlalgebrajs_1 = require("sparqlalgebrajs");
const SyncEvaluator_1 = require("../lib/evaluators/SyncEvaluator");
const Types_1 = require("../lib/Types");
const USAGE = `
Usage: sparqlee <expression>
Example: sparqlee 'concat("foo", "bar")'
`;
function template(expr) {
    return `
PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>
PREFIX fn: <https://www.w3.org/TR/xpath-functions#>
PREFIX err: <http://www.w3.org/2005/xqt-errors#>
PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>

SELECT * WHERE { ?s ?p ?o FILTER (${expr})}
`;
}
function parse(query) {
    const sparqlQuery = sparqlalgebrajs_1.translate(query);
    // Extract filter expression from complete query
    return sparqlQuery.input.expression;
}
async function main() {
    if (process.argv.length < 3) {
        console.log(USAGE);
        return;
    }
    const input = process.argv[2];
    const expression = parse(template(input));
    const evaluator = new SyncEvaluator_1.SyncEvaluator(expression);
    const result = evaluator.evaluate(Types_1.Bindings({}));
    console.log(result);
}
main();
//# sourceMappingURL=Sparqlee.js.map