import * as RDF from 'rdf-js';
import { Algebra as Alg } from 'sparqlalgebrajs';
import * as E from './expressions';
export declare function transformAlgebra(expr: Alg.Expression): E.Expression;
/**
 * Transforms an RDF term to the internal representation of a term,
 * assuming it is not a variable, which would be an expression (internally).
 *
 * @param term RDF term to transform into internal representation of a term
 */
export declare function transformRDFTermUnsafe(term: RDF.Term): E.Term;
export declare function transformLiteral(lit: RDF.Literal): E.Literal<any>;
export declare function transformNamed(expr: Alg.NamedExpression): E.NamedExpression;
export declare function transformAggregate(expr: Alg.AggregateExpression): E.Aggregate;
export declare function transformExistence(expr: Alg.ExistenceExpression): E.Existence;
