import { Map } from 'immutable';
import * as RDF from 'rdf-js';
/**
 * An immutable solution mapping object.
 * This maps variables to a terms.
 *
 * Variables are represented as strings containing the variable name (without '?').
 * Terms are named nodes, literals or the default graph.
 */
export declare type Bindings = Map<string, RDF.Term>;
/**
 * A convenience constructor for bindings based on a given hash.
 * @param {{[p: string]: RDF.Term}} hash A hash that maps variable names to terms.
 * @return {Bindings} The immutable bindings from the hash.
 * @constructor
 */
export declare function Bindings(hash: {
    [key: string]: RDF.Term;
}): Bindings;
export interface ExpressionEvaluator<ExpressionType, TermType> {
    evaluate(expr: ExpressionType, mapping: Bindings): TermType;
}
