import * as RDF from 'rdf-js';
import { Algebra } from 'sparqlalgebrajs';
import { Bindings } from '../Types';
import { SetFunction } from './../util/Consts';
import { SyncEvaluatorConfig } from './SyncEvaluator';
export declare class AggregateEvaluator {
    private expression;
    private aggregator;
    private evaluator;
    private throwError;
    private state;
    constructor(expr: Algebra.AggregateExpression, config?: SyncEvaluatorConfig, throwError?: boolean);
    /**
     * The spec says to throw an error when a set function is called on an empty
     * set (unless explicitly mentioned otherwise like COUNT).
     * However, aggregate error handling says to not bind the result in case of an
     * error. So to simplify logic in the caller, we return undefined by default.
     *
     * @param throwError wether this function should respect the spec and throw an error if no empty value is defined
     */
    static emptyValue(expr: Algebra.AggregateExpression, throwError?: boolean): RDF.Term;
    /**
     * Put a binding from the result stream in the aggregate state.
     *
     * If any binding evaluation errors, the corresponding aggregate variable should be unbound.
     * If this happens, calling @see result() will return @constant undefined
     *
     * @param bindings the bindings to pass to the expression
     */
    put(bindings: Bindings): void;
    result(): RDF.Term;
    /**
     * The actual put method. When the first binding has been given, and the state
     * of the evaluators initialised. The .put API function will be replaced with this
     * function, which implements the behaviour we want.
     *
     * @param bindings the bindings to pass to the expression
     */
    private __put;
    /**
     * The actual result method. When the first binding has been given, and the state
     * of the evaluators initialised. The .result API function will be replaced with this
     * function, which implements the behaviour we want.
     *
     * @param bindings the bindings to pass to the expression
     */
    private __result;
    private init;
    private safeThrow;
}
declare abstract class BaseAggregator<State> {
    protected distinct: boolean;
    protected separator: string;
    constructor(expr: Algebra.AggregateExpression);
    static emptyValue(): RDF.Term;
    abstract init(start: RDF.Term): State;
    abstract result(state: State): RDF.Term;
    abstract put(state: State, bindings: RDF.Term): State;
}
export interface AggregatorClass {
    new (expr: Algebra.AggregateExpression): BaseAggregator<any>;
    emptyValue(): RDF.Term;
}
export declare const aggregators: Readonly<{
    [key in SetFunction]: AggregatorClass;
}>;
export {};
