import * as RDF from 'rdf-js';
import { Algebra as Alg } from 'sparqlalgebrajs';
import * as E from '../expressions/Expressions';
import { Bindings } from '../Types';
declare type Term = E.TermExpression;
export interface AsyncEvaluatorConfig {
    now?: Date;
    baseIRI?: string;
    exists?: (expression: Alg.ExistenceExpression, mapping: Bindings) => Promise<boolean>;
    aggregate?: (expression: Alg.AggregateExpression) => Promise<RDF.Term>;
    bnode?: (input?: string) => Promise<RDF.BlankNode>;
}
export declare type AsyncEvaluatorContext = AsyncEvaluatorConfig & {
    now: Date;
};
export declare class AsyncEvaluator {
    algExpr: Alg.Expression;
    config: AsyncEvaluatorConfig;
    private expr;
    private evaluator;
    constructor(algExpr: Alg.Expression, config?: AsyncEvaluatorConfig);
    evaluate(mapping: Bindings): Promise<RDF.Term>;
    evaluateAsEBV(mapping: Bindings): Promise<boolean>;
    evaluateAsInternal(mapping: Bindings): Promise<Term>;
}
export {};
