"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Transformation_1 = require("../Transformation");
const RecursiveExpressionEvaluator_1 = require("./RecursiveExpressionEvaluator");
class AsyncEvaluator {
    constructor(algExpr, config = {}) {
        this.algExpr = algExpr;
        this.config = config;
        this.expr = Transformation_1.transformAlgebra(algExpr);
        const context = {
            now: config.now || new Date(Date.now()),
            baseIRI: config.baseIRI || undefined,
            exists: config.exists,
            aggregate: config.aggregate,
        };
        this.evaluator = new RecursiveExpressionEvaluator_1.AsyncRecursiveEvaluator(context);
    }
    async evaluate(mapping) {
        const result = await this.evaluator.evaluate(this.expr, mapping);
        return log(result).toRDF();
    }
    async evaluateAsEBV(mapping) {
        const result = await this.evaluator.evaluate(this.expr, mapping);
        return log(result).coerceEBV();
    }
    async evaluateAsInternal(mapping) {
        const result = await this.evaluator.evaluate(this.expr, mapping);
        return log(result);
    }
}
exports.AsyncEvaluator = AsyncEvaluator;
function log(val) {
    // console.log(val);
    return val;
}
//# sourceMappingURL=AsyncEvaluator.js.map