import * as RDF from 'rdf-js';
import { Algebra as Alg } from 'sparqlalgebrajs';
import * as E from '../expressions/Expressions';
import { Bindings, Hooks } from '../Types';
declare type Term = E.TermExpression;
export declare class Evaluator {
    algExpr: Alg.Expression;
    hooks: Hooks;
    private expr;
    private evaluator;
    private evaluatorSync;
    constructor(algExpr: Alg.Expression, hooks?: Hooks);
    evaluate(mapping: Bindings): Promise<RDF.Term>;
    evaluateAsEBV(mapping: Bindings): Promise<boolean>;
    evaluateAsInternal(mapping: Bindings): Promise<Term>;
    evaluateSync(mapping: Bindings): RDF.Term;
    evaluateAsEBVSync(mapping: Bindings): boolean;
    evaluateAsInternalSync(mapping: Bindings): Term;
}
export {};
