"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Transformation_1 = require("../Transformation");
const RecursiveExpressionEvaluator_1 = require("./RecursiveExpressionEvaluator");
class Evaluator {
    constructor(algExpr, hooks = {}) {
        this.algExpr = algExpr;
        this.hooks = hooks;
        this.expr = Transformation_1.transformAlgebra(algExpr, hooks);
        this.evaluator = new RecursiveExpressionEvaluator_1.AsyncRecursiveEvaluator();
        this.evaluatorSync = new RecursiveExpressionEvaluator_1.SyncRecursiveEvaluator();
    }
    // Async API ----------------------------------------------------------------
    async evaluate(mapping) {
        const result = await this.evaluator.evaluate(this.expr, mapping);
        return log(result).toRDF();
    }
    async evaluateAsEBV(mapping) {
        const result = await this.evaluator.evaluate(this.expr, mapping);
        return log(result).coerceEBV();
    }
    async evaluateAsInternal(mapping) {
        const result = await this.evaluator.evaluate(this.expr, mapping);
        return log(result);
    }
    // Sync API -----------------------------------------------------------------
    evaluateSync(mapping) {
        const result = this.evaluatorSync.evaluate(this.expr, mapping);
        return log(result).toRDF();
    }
    evaluateAsEBVSync(mapping) {
        const result = this.evaluatorSync.evaluate(this.expr, mapping);
        return log(result).coerceEBV();
    }
    evaluateAsInternalSync(mapping) {
        const result = this.evaluatorSync.evaluate(this.expr, mapping);
        return log(result);
    }
}
exports.Evaluator = Evaluator;
function log(val) {
    // console.log(val);
    return val;
}
//# sourceMappingURL=Evaluator.js.map