import * as E from '../expressions';
import { Bindings, ExpressionEvaluator } from '../Types';
import { AsyncEvaluatorContext } from './AsyncEvaluator';
import { SyncEvaluatorContext } from './SyncEvaluator';
declare type Expression = E.Expression;
declare type Term = E.TermExpression;
export declare class AsyncRecursiveEvaluator implements ExpressionEvaluator<Expression, Promise<Term>> {
    private context;
    private readonly subEvaluators;
    constructor(context: AsyncEvaluatorContext);
    evaluate(expr: Expression, mapping: Bindings): Promise<Term>;
    private evalOperator;
    private evalSpecialOperator;
    private evalNamed;
    private evalExistence;
    private evalAggregate;
}
export declare class SyncRecursiveEvaluator implements ExpressionEvaluator<Expression, Term> {
    private context;
    private readonly subEvaluators;
    constructor(context: SyncEvaluatorContext);
    evaluate(expr: Expression, mapping: Bindings): Term;
    private evalOperator;
    private evalSpecialOperator;
    private evalNamed;
    private evalExistence;
    private evalAggregate;
}
export declare class UnsupportedOperation extends Error {
    constructor(operation: string);
}
export {};
