import * as RDF from 'rdf-js';
import { Algebra as Alg } from 'sparqlalgebrajs';
import * as E from '../expressions/Expressions';
import { Bindings } from '../Types';
declare type Term = E.TermExpression;
/**
 * Evaluator that does not support EXISTS, AGGREGATES or custom Named operators.
 * Evaluates everything sync.
 */
export declare class SimpleEvaluator {
    algExpr: Alg.Expression;
    private expr;
    constructor(algExpr: Alg.Expression);
    evaluate(mapping: Bindings): RDF.Term;
    evaluateAsEBV(mapping: Bindings): boolean;
    evaluateAsInternal(mapping: Bindings): Term;
    private readonly evaluators;
    private evalRecursive;
    private evalTerm;
    private evalVariable;
    private evalOperator;
    private evalSpecialOperator;
    private evalNamed;
    private evalExistence;
    private evalAggregate;
}
export declare class UnsupportedOperation extends Error {
    constructor(operation: string);
}
export {};
