import * as RDF from 'rdf-js';
import { Algebra as Alg } from 'sparqlalgebrajs';
import * as E from '../expressions/Expressions';
import { Bindings } from '../Types';
declare type Term = E.TermExpression;
export interface SyncEvaluatorConfig {
    now?: Date;
    baseIRI?: string;
    exists?: (expression: Alg.ExistenceExpression, mapping: Bindings) => boolean;
    aggregate?: (expression: Alg.AggregateExpression) => RDF.Term;
    bnode?: (input?: string) => RDF.BlankNode;
}
export declare type SyncEvaluatorContext = SyncEvaluatorConfig & {
    now: Date;
};
export declare class SyncEvaluator {
    algExpr: Alg.Expression;
    config: SyncEvaluatorConfig;
    private expr;
    private evaluator;
    constructor(algExpr: Alg.Expression, config?: SyncEvaluatorConfig);
    evaluate(mapping: Bindings): RDF.Term;
    evaluateAsEBV(mapping: Bindings): boolean;
    evaluateAsInternal(mapping: Bindings): Term;
}
export {};
