"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Transformation_1 = require("../Transformation");
const RecursiveExpressionEvaluator_1 = require("./RecursiveExpressionEvaluator");
class SyncEvaluator {
    constructor(algExpr, config = {}) {
        this.algExpr = algExpr;
        this.config = config;
        this.expr = Transformation_1.transformAlgebra(algExpr);
        const context = {
            now: config.now || new Date(Date.now()),
            baseIRI: config.baseIRI || undefined,
            exists: config.exists,
            aggregate: config.aggregate,
        };
        this.evaluator = new RecursiveExpressionEvaluator_1.SyncRecursiveEvaluator(context);
    }
    evaluate(mapping) {
        const result = this.evaluator.evaluate(this.expr, mapping);
        return log(result).toRDF();
    }
    evaluateAsEBV(mapping) {
        const result = this.evaluator.evaluate(this.expr, mapping);
        return log(result).coerceEBV();
    }
    evaluateAsInternal(mapping) {
        const result = this.evaluator.evaluate(this.expr, mapping);
        return log(result);
    }
}
exports.SyncEvaluator = SyncEvaluator;
function log(val) {
    // console.log(val);
    return val;
}
//# sourceMappingURL=SyncEvaluator.js.map