import * as RDF from 'rdf-js';
import { Algebra } from 'sparqlalgebrajs';
import { Bindings } from '../Types';
export declare enum ExpressionType {
    Aggregate = "aggregate",
    Existence = "existence",
    Named = "named",
    Operator = "operator",
    SpecialOperator = "specialOperator",
    Term = "term",
    Variable = "variable"
}
export declare type Expression = AggregateExpression | ExistenceExpression | NamedExpression | OperatorExpression | SpecialOperatorExpression | TermExpression | VariableExpression;
export interface ExpressionProps {
    expressionType: ExpressionType;
}
export declare type AggregateExpression = ExpressionProps & {
    expressionType: ExpressionType.Aggregate;
    name: string;
    expression: Algebra.AggregateExpression;
};
export declare type ExistenceExpression = ExpressionProps & {
    expressionType: ExpressionType.Existence;
    expression: Algebra.ExistenceExpression;
};
export declare type NamedExpression = ExpressionProps & {
    expressionType: ExpressionType.Named;
    name: RDF.NamedNode;
    apply: SimpleApplication;
    args: Expression[];
};
export declare type SimpleApplication = (args: TermExpression[]) => TermExpression;
export declare type OperatorExpression = ExpressionProps & {
    expressionType: ExpressionType.Operator;
    args: Expression[];
    apply: SimpleApplication;
};
export declare type SpecialApplication<Term, BNode> = (context: EvalContext<Term, BNode>) => Term;
export declare type SpecialApplicationAsync = SpecialApplication<Promise<TermExpression>, Promise<RDF.BlankNode>>;
export declare type EvalContextAsync = EvalContext<Promise<TermExpression>, Promise<RDF.BlankNode>>;
export declare type SpecialApplicationSync = SpecialApplication<TermExpression, RDF.BlankNode>;
export declare type EvalContextSync = EvalContext<TermExpression, RDF.BlankNode>;
export declare type EvalContext<Term, BNode> = {
    args: Expression[];
    mapping: Bindings;
    context: {
        now: Date;
        baseIRI?: string;
        bnode(input?: string): BNode;
    };
    evaluate(expr: Expression, mapping: Bindings): Term;
};
export declare type SpecialOperatorExpression = ExpressionProps & {
    expressionType: ExpressionType.SpecialOperator;
    args: Expression[];
    applyAsync: SpecialApplicationAsync;
    applySync: SpecialApplicationSync;
};
export declare type TermType = 'namedNode' | 'literal' | 'blankNode';
export declare type TermExpression = ExpressionProps & {
    expressionType: ExpressionType.Term;
    termType: TermType;
    str(): string;
    coerceEBV(): boolean;
    toRDF(): RDF.Term;
};
export declare type VariableExpression = ExpressionProps & {
    expressionType: ExpressionType.Variable;
    name: string;
};
