import * as RDF from 'rdf-js';
import { ExpressionType, TermExpression, TermType } from './Expressions';
import * as C from '../util/Consts';
export declare abstract class Term implements TermExpression {
    expressionType: ExpressionType.Term;
    abstract termType: TermType;
    abstract toRDF(): RDF.Term;
    str(): string;
    coerceEBV(): boolean;
}
export declare class NamedNode extends Term {
    value: string;
    termType: TermType;
    constructor(value: string);
    toRDF(): RDF.Term;
    str(): string;
}
export declare class BlankNode extends Term {
    value: string;
    static _nextID: number;
    termType: TermType;
    constructor(value: string);
    static nextID(): string;
    toRDF(): RDF.Term;
}
export declare class Literal<T> extends Term {
    typedValue: T;
    typeURL: RDF.NamedNode;
    strValue?: string;
    language?: string;
    termType: 'literal';
    type: C.Type;
    constructor(typedValue: T, typeURL: RDF.NamedNode, strValue?: string, language?: string);
    toRDF(): RDF.Term;
    str(): string;
}
export declare class NumericLiteral extends Literal<number> {
    private static specificFormatters;
    type: C.PrimitiveNumericType;
    coerceEBV(): boolean;
    toRDF(): RDF.Term;
    str(): string;
}
export declare class BooleanLiteral extends Literal<boolean> {
    typedValue: boolean;
    strValue?: string;
    constructor(typedValue: boolean, strValue?: string);
    coerceEBV(): boolean;
}
export declare class DateTimeLiteral extends Literal<Date> {
    typedValue: Date;
    strValue: string;
    constructor(typedValue: Date, strValue: string);
}
export declare class LangStringLiteral extends Literal<string> {
    typedValue: string;
    language: string;
    constructor(typedValue: string, language: string);
    coerceEBV(): boolean;
}
export declare class StringLiteral extends Literal<string> {
    typedValue: string;
    constructor(typedValue: string);
    coerceEBV(): boolean;
}
export declare class NonLexicalLiteral extends Literal<undefined> {
    private shouldBeCategory;
    constructor(typedValue: undefined, typeURL: RDF.NamedNode, strValue?: string, language?: string);
    coerceEBV(): boolean;
}
