import { Set } from 'immutable';
import * as RDF from 'rdf-js';
export declare const TRUE_STR = "\"true\"^^xsd:boolean";
export declare const FALSE_STR = "\"false\"^^xsd:boolean";
export declare const EVB_ERR_STR = "\"not an dateTime\"^^xsd:dateTime";
export declare enum TypeURL {
    XSD_ANY_URI = "http://www.w3.org/2001/XMLSchema#anyURI",
    XSD_STRING = "http://www.w3.org/2001/XMLSchema#string",
    RDF_LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString",
    XSD_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean",
    XSD_DATE_TIME = "http://www.w3.org/2001/XMLSchema#dateTime",
    XSD_INTEGER = "http://www.w3.org/2001/XMLSchema#integer",
    XSD_DECIMAL = "http://www.w3.org/2001/XMLSchema#decimal",
    XSD_FLOAT = "http://www.w3.org/2001/XMLSchema#float",
    XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double",
    XSD_NON_POSITIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#nonPositiveInteger",
    XSD_NEGATIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#negativeInteger",
    XSD_LONG = "http://www.w3.org/2001/XMLSchema#long",
    XSD_INT = "http://www.w3.org/2001/XMLSchema#int",
    XSD_SHORT = "http://www.w3.org/2001/XMLSchema#short",
    XSD_BYTE = "http://www.w3.org/2001/XMLSchema#byte",
    XSD_NON_NEGATIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#nonNegativeInteger",
    XSD_UNSIGNED_LONG = "http://www.w3.org/2001/XMLSchema#unsignedLong",
    XSD_UNSIGNED_INT = "http://www.w3.org/2001/XMLSchema#unsignedInt",
    XSD_UNSIGNED_SHORT = "http://www.w3.org/2001/XMLSchema#unsignedShort",
    XSD_UNSIGNED_BYTE = "http://www.w3.org/2001/XMLSchema#unsignedByte",
    XSD_POSITIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#positiveInteger",
    XSD_DAYTIME_DURATION = "http://www.w3.org/2001/XMLSchema#dayTimeDuration"
}
export declare function make(dt: TypeURL): RDF.NamedNode;
export declare enum NumericTypeURL {
    XSD_INTEGER = "http://www.w3.org/2001/XMLSchema#integer",
    XSD_DECIMAL = "http://www.w3.org/2001/XMLSchema#decimal",
    XSD_FLOAT = "http://www.w3.org/2001/XMLSchema#float",
    XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double",
    XSD_NON_POSITIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#nonPositiveInteger",
    XSD_NEGATIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#negativeInteger",
    XSD_LONG = "http://www.w3.org/2001/XMLSchema#long",
    XSD_INT = "http://www.w3.org/2001/XMLSchema#int",
    XSD_SHORT = "http://www.w3.org/2001/XMLSchema#short",
    XSD_BYTE = "http://www.w3.org/2001/XMLSchema#byte",
    XSD_NON_NEGATIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#nonNegativeInteger",
    XSD_UNSIGNED_LONG = "http://www.w3.org/2001/XMLSchema#unsignedLong",
    XSD_UNSIGNED_INT = "http://www.w3.org/2001/XMLSchema#unsignedInt",
    XSD_UNSIGNED_SHORT = "http://www.w3.org/2001/XMLSchema#unsignedShort",
    XSD_UNSIGNED_BYTE = "http://www.w3.org/2001/XMLSchema#unsignedByte",
    XSD_POSITIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#positiveInteger"
}
export declare enum DerivedIntegerTypeURL {
    XSD_NON_POSITIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#nonPositiveInteger",
    XSD_NEGATIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#negativeInteger",
    XSD_LONG = "http://www.w3.org/2001/XMLSchema#long",
    XSD_INT = "http://www.w3.org/2001/XMLSchema#int",
    XSD_SHORT = "http://www.w3.org/2001/XMLSchema#short",
    XSD_BYTE = "http://www.w3.org/2001/XMLSchema#byte",
    XSD_NON_NEGATIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#nonNegativeInteger",
    XSD_UNSIGNED_LONG = "http://www.w3.org/2001/XMLSchema#unsignedLong",
    XSD_UNSIGNED_INT = "http://www.w3.org/2001/XMLSchema#unsignedInt",
    XSD_UNSIGNED_SHORT = "http://www.w3.org/2001/XMLSchema#unsignedShort",
    XSD_UNSIGNED_BYTE = "http://www.w3.org/2001/XMLSchema#unsignedByte",
    XSD_POSITIVE_INTEGER = "http://www.w3.org/2001/XMLSchema#positiveInteger"
}
export declare const NumericTypeURLs: Set<any>;
export declare const DerivedIntegerTypeURLs: Set<any>;
export declare const commonTerms: {
    [key: string]: RDF.Term;
};
export declare type Type = 'string' | 'langString' | 'date' | 'boolean' | 'integer' | 'decimal' | 'float' | 'double' | 'other' | 'nonlexical';
export declare type PrimitiveNumericType = 'integer' | 'decimal' | 'float' | 'double';
export declare const PrimitiveNumericTypes: Set<string>;
export declare function type(typeURL: string): Type;
export declare function decategorize(cat: PrimitiveNumericType): TypeURL;
export declare type OperatorCategory = 'regular' | 'special';
export declare type Operator = RegularOperator | SpecialOperator;
export declare enum RegularOperator {
    NOT = "!",
    UMINUS = "UMINUS",
    UPLUS = "UPLUS",
    EQUAL = "=",
    NOT_EQUAL = "!=",
    LT = "<",
    GT = ">",
    LTE = "<=",
    GTE = ">=",
    MULTIPLICATION = "*",
    DIVISION = "/",
    ADDITION = "+",
    SUBTRACTION = "-",
    IS_IRI = "isiri",
    IS_BLANK = "isblank",
    IS_LITERAL = "isliteral",
    IS_NUMERIC = "isnumeric",
    STR = "str",
    LANG = "lang",
    DATATYPE = "datatype",
    STRDT = "strdt",
    STRLANG = "strlang",
    UUID = "uuid",
    STRUUID = "struuid",
    STRLEN = "strlen",
    SUBSTR = "substr",
    UCASE = "ucase",
    LCASE = "lcase",
    STRSTARTS = "strstarts",
    STRENDS = "strends",
    CONTAINS = "contains",
    STRBEFORE = "strbefore",
    STRAFTER = "strafter",
    ENCODE_FOR_URI = "encode_for_uri",
    LANG_MATCHES = "langmatches",
    REGEX = "regex",
    REPLACE = "replace",
    ABS = "abs",
    ROUND = "round",
    CEIL = "ceil",
    FLOOR = "floor",
    RAND = "rand",
    YEAR = "year",
    MONTH = "month",
    DAY = "day",
    HOURS = "hours",
    MINUTES = "minutes",
    SECONDS = "seconds",
    TIMEZONE = "timezone",
    TZ = "tz",
    MD5 = "md5",
    SHA1 = "sha1",
    SHA256 = "sha256",
    SHA384 = "sha384",
    SHA512 = "sha512"
}
export declare enum SpecialOperator {
    BOUND = "bound",
    IF = "if",
    COALESCE = "coalesce",
    LOGICAL_OR = "||",
    LOGICAL_AND = "&&",
    SAME_TERM = "sameterm",
    IN = "in",
    NOT_IN = "notin",
    CONCAT = "concat",
    NOW = "now",
    IRI = "iri",
    URI = "uri",
    BNODE = "BNODE"
}
export declare const RegularOperators: Set<any>;
export declare const SpecialOperators: Set<any>;
export declare const Operators: Set<any>;
export declare enum SetFunction {
    COUNT = "count",
    SUM = "sum",
    MIN = "min",
    MAX = "max",
    AVG = "avg",
    GROUP_CONCAT = "group_concat",
    SAMPLE = "sample"
}
export declare const SetFunctions: Set<any>;
export declare type NamedOperator = TypeURL.XSD_STRING | TypeURL.XSD_FLOAT | TypeURL.XSD_DOUBLE | TypeURL.XSD_DECIMAL | TypeURL.XSD_INTEGER | TypeURL.XSD_DATE_TIME | TypeURL.XSD_BOOLEAN;
export declare const NamedOperators: Set<TypeURL>;
