"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:variable-name
const RDFDM = require("@rdfjs/data-model");
const immutable_1 = require("immutable");
exports.TRUE_STR = '"true"^^xsd:boolean';
exports.FALSE_STR = '"false"^^xsd:boolean';
exports.EVB_ERR_STR = '"not an dateTime"^^xsd:dateTime';
// TODO: Consider inlining all with 'const enum'
var TypeURL;
(function (TypeURL) {
    TypeURL["XSD_ANY_URI"] = "http://www.w3.org/2001/XMLSchema#anyURI";
    TypeURL["XSD_STRING"] = "http://www.w3.org/2001/XMLSchema#string";
    TypeURL["RDF_LANG_STRING"] = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    TypeURL["XSD_BOOLEAN"] = "http://www.w3.org/2001/XMLSchema#boolean";
    TypeURL["XSD_DATE_TIME"] = "http://www.w3.org/2001/XMLSchema#dateTime";
    // Numeric types
    TypeURL["XSD_INTEGER"] = "http://www.w3.org/2001/XMLSchema#integer";
    TypeURL["XSD_DECIMAL"] = "http://www.w3.org/2001/XMLSchema#decimal";
    TypeURL["XSD_FLOAT"] = "http://www.w3.org/2001/XMLSchema#float";
    TypeURL["XSD_DOUBLE"] = "http://www.w3.org/2001/XMLSchema#double";
    // Derived numeric types
    TypeURL["XSD_NON_POSITIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#nonPositiveInteger";
    TypeURL["XSD_NEGATIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#negativeInteger";
    TypeURL["XSD_LONG"] = "http://www.w3.org/2001/XMLSchema#long";
    TypeURL["XSD_INT"] = "http://www.w3.org/2001/XMLSchema#int";
    TypeURL["XSD_SHORT"] = "http://www.w3.org/2001/XMLSchema#short";
    TypeURL["XSD_BYTE"] = "http://www.w3.org/2001/XMLSchema#byte";
    TypeURL["XSD_NON_NEGATIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#nonNegativeInteger";
    TypeURL["XSD_UNSIGNED_LONG"] = "http://www.w3.org/2001/XMLSchema#unsignedLong";
    TypeURL["XSD_UNSIGNED_INT"] = "http://www.w3.org/2001/XMLSchema#unsignedInt";
    TypeURL["XSD_UNSIGNED_SHORT"] = "http://www.w3.org/2001/XMLSchema#unsignedShort";
    TypeURL["XSD_UNSIGNED_BYTE"] = "http://www.w3.org/2001/XMLSchema#unsignedByte";
    TypeURL["XSD_POSITIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#positiveInteger";
    // Other types
    TypeURL["XSD_DAYTIME_DURATION"] = "http://www.w3.org/2001/XMLSchema#dayTimeDuration";
})(TypeURL = exports.TypeURL || (exports.TypeURL = {}));
function make(dt) {
    return RDFDM.namedNode(dt);
}
exports.make = make;
// https://www.w3.org/TR/sparql11-query/#operandDataTypes
var NumericTypeURL;
(function (NumericTypeURL) {
    // Numeric types
    NumericTypeURL["XSD_INTEGER"] = "http://www.w3.org/2001/XMLSchema#integer";
    NumericTypeURL["XSD_DECIMAL"] = "http://www.w3.org/2001/XMLSchema#decimal";
    NumericTypeURL["XSD_FLOAT"] = "http://www.w3.org/2001/XMLSchema#float";
    NumericTypeURL["XSD_DOUBLE"] = "http://www.w3.org/2001/XMLSchema#double";
    // Derived numeric types
    NumericTypeURL["XSD_NON_POSITIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#nonPositiveInteger";
    NumericTypeURL["XSD_NEGATIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#negativeInteger";
    NumericTypeURL["XSD_LONG"] = "http://www.w3.org/2001/XMLSchema#long";
    NumericTypeURL["XSD_INT"] = "http://www.w3.org/2001/XMLSchema#int";
    NumericTypeURL["XSD_SHORT"] = "http://www.w3.org/2001/XMLSchema#short";
    NumericTypeURL["XSD_BYTE"] = "http://www.w3.org/2001/XMLSchema#byte";
    NumericTypeURL["XSD_NON_NEGATIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#nonNegativeInteger";
    NumericTypeURL["XSD_UNSIGNED_LONG"] = "http://www.w3.org/2001/XMLSchema#unsignedLong";
    NumericTypeURL["XSD_UNSIGNED_INT"] = "http://www.w3.org/2001/XMLSchema#unsignedInt";
    NumericTypeURL["XSD_UNSIGNED_SHORT"] = "http://www.w3.org/2001/XMLSchema#unsignedShort";
    NumericTypeURL["XSD_UNSIGNED_BYTE"] = "http://www.w3.org/2001/XMLSchema#unsignedByte";
    NumericTypeURL["XSD_POSITIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#positiveInteger";
})(NumericTypeURL = exports.NumericTypeURL || (exports.NumericTypeURL = {}));
var DerivedIntegerTypeURL;
(function (DerivedIntegerTypeURL) {
    DerivedIntegerTypeURL["XSD_NON_POSITIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#nonPositiveInteger";
    DerivedIntegerTypeURL["XSD_NEGATIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#negativeInteger";
    DerivedIntegerTypeURL["XSD_LONG"] = "http://www.w3.org/2001/XMLSchema#long";
    DerivedIntegerTypeURL["XSD_INT"] = "http://www.w3.org/2001/XMLSchema#int";
    DerivedIntegerTypeURL["XSD_SHORT"] = "http://www.w3.org/2001/XMLSchema#short";
    DerivedIntegerTypeURL["XSD_BYTE"] = "http://www.w3.org/2001/XMLSchema#byte";
    DerivedIntegerTypeURL["XSD_NON_NEGATIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#nonNegativeInteger";
    DerivedIntegerTypeURL["XSD_UNSIGNED_LONG"] = "http://www.w3.org/2001/XMLSchema#unsignedLong";
    DerivedIntegerTypeURL["XSD_UNSIGNED_INT"] = "http://www.w3.org/2001/XMLSchema#unsignedInt";
    DerivedIntegerTypeURL["XSD_UNSIGNED_SHORT"] = "http://www.w3.org/2001/XMLSchema#unsignedShort";
    DerivedIntegerTypeURL["XSD_UNSIGNED_BYTE"] = "http://www.w3.org/2001/XMLSchema#unsignedByte";
    DerivedIntegerTypeURL["XSD_POSITIVE_INTEGER"] = "http://www.w3.org/2001/XMLSchema#positiveInteger";
})(DerivedIntegerTypeURL = exports.DerivedIntegerTypeURL || (exports.DerivedIntegerTypeURL = {}));
exports.NumericTypeURLs = immutable_1.Set(Object.values(NumericTypeURL));
exports.DerivedIntegerTypeURLs = immutable_1.Set(Object.values(DerivedIntegerTypeURL));
exports.commonTerms = {
    true: RDFDM.literal('true', RDFDM.namedNode(TypeURL.XSD_BOOLEAN)),
    false: RDFDM.literal('false', RDFDM.namedNode(TypeURL.XSD_BOOLEAN)),
};
exports.PrimitiveNumericTypes = immutable_1.Set(['integer', 'decimal', 'float', 'double']);
function type(typeURL) {
    switch (typeURL) {
        case null:
        case undefined:
        case '':
        case TypeURL.XSD_ANY_URI: return 'string';
        case TypeURL.XSD_STRING: return 'string';
        case TypeURL.RDF_LANG_STRING: return 'langString';
        case TypeURL.XSD_DATE_TIME: return 'date';
        case TypeURL.XSD_BOOLEAN: return 'boolean';
        case TypeURL.XSD_DECIMAL: return 'decimal';
        case TypeURL.XSD_FLOAT: return 'float';
        case TypeURL.XSD_DOUBLE: return 'double';
        case TypeURL.XSD_INTEGER:
        case TypeURL.XSD_NON_POSITIVE_INTEGER:
        case TypeURL.XSD_NEGATIVE_INTEGER:
        case TypeURL.XSD_LONG:
        case TypeURL.XSD_INT:
        case TypeURL.XSD_SHORT:
        case TypeURL.XSD_BYTE:
        case TypeURL.XSD_NON_NEGATIVE_INTEGER:
        case TypeURL.XSD_UNSIGNED_LONG:
        case TypeURL.XSD_UNSIGNED_INT:
        case TypeURL.XSD_UNSIGNED_SHORT:
        case TypeURL.XSD_UNSIGNED_BYTE:
        case TypeURL.XSD_POSITIVE_INTEGER: return 'integer';
        default: return 'other';
    }
}
exports.type = type;
// If datatypes get lost or lose specificity during operations, we can insert a
// concrete type, since categories should remain the same. This mostly (only)
// relevant for integer subtypes.
const _decategorize = immutable_1.Map([
    ['integer', TypeURL.XSD_INTEGER],
    ['float', TypeURL.XSD_FLOAT],
    ['double', TypeURL.XSD_DOUBLE],
    ['decimal', TypeURL.XSD_DECIMAL],
]);
function decategorize(cat) {
    return _decategorize.get(cat);
}
exports.decategorize = decategorize;
// TODO: Remove unneeded double typing
var RegularOperator;
(function (RegularOperator) {
    // Operator mapping
    // https://www.w3.org/TR/sparql11-query/#OperatorMapping
    RegularOperator["NOT"] = "!";
    RegularOperator["UMINUS"] = "UMINUS";
    RegularOperator["UPLUS"] = "UPLUS";
    // LOGICAL_AND // See SpecialOperators
    // LOGICAL_OR  // See SpecialOperators
    RegularOperator["EQUAL"] = "=";
    RegularOperator["NOT_EQUAL"] = "!=";
    RegularOperator["LT"] = "<";
    RegularOperator["GT"] = ">";
    RegularOperator["LTE"] = "<=";
    RegularOperator["GTE"] = ">=";
    RegularOperator["MULTIPLICATION"] = "*";
    RegularOperator["DIVISION"] = "/";
    RegularOperator["ADDITION"] = "+";
    RegularOperator["SUBTRACTION"] = "-";
    // Functional Forms
    // https://www.w3.org/TR/sparql11-query/#func-forms
    // See SpecialOperators
    // Functions on RDF Terms
    // https://www.w3.org/TR/sparql11-query/#func-rdfTerms
    RegularOperator["IS_IRI"] = "isiri";
    RegularOperator["IS_BLANK"] = "isblank";
    RegularOperator["IS_LITERAL"] = "isliteral";
    RegularOperator["IS_NUMERIC"] = "isnumeric";
    RegularOperator["STR"] = "str";
    RegularOperator["LANG"] = "lang";
    RegularOperator["DATATYPE"] = "datatype";
    // IRI = 'iri', (see special operators)
    // URI = 'uri', (see special operators)
    // BNODE = 'BNODE', (see special operators)
    RegularOperator["STRDT"] = "strdt";
    RegularOperator["STRLANG"] = "strlang";
    RegularOperator["UUID"] = "uuid";
    RegularOperator["STRUUID"] = "struuid";
    // Functions on strings
    // https://www.w3.org/TR/sparql11-query/#func-strings
    RegularOperator["STRLEN"] = "strlen";
    RegularOperator["SUBSTR"] = "substr";
    RegularOperator["UCASE"] = "ucase";
    RegularOperator["LCASE"] = "lcase";
    RegularOperator["STRSTARTS"] = "strstarts";
    RegularOperator["STRENDS"] = "strends";
    RegularOperator["CONTAINS"] = "contains";
    RegularOperator["STRBEFORE"] = "strbefore";
    RegularOperator["STRAFTER"] = "strafter";
    RegularOperator["ENCODE_FOR_URI"] = "encode_for_uri";
    // CONCAT = 'concat' (see special operators)
    RegularOperator["LANG_MATCHES"] = "langmatches";
    RegularOperator["REGEX"] = "regex";
    RegularOperator["REPLACE"] = "replace";
    // Functions on numerics
    // https://www.w3.org/TR/sparql11-query/#func-numerics
    RegularOperator["ABS"] = "abs";
    RegularOperator["ROUND"] = "round";
    RegularOperator["CEIL"] = "ceil";
    RegularOperator["FLOOR"] = "floor";
    RegularOperator["RAND"] = "rand";
    // Functions on Dates and Times
    // https://www.w3.org/TR/sparql11-query/#func-date-time
    // NOW = 'now' (see special operators)
    RegularOperator["YEAR"] = "year";
    RegularOperator["MONTH"] = "month";
    RegularOperator["DAY"] = "day";
    RegularOperator["HOURS"] = "hours";
    RegularOperator["MINUTES"] = "minutes";
    RegularOperator["SECONDS"] = "seconds";
    RegularOperator["TIMEZONE"] = "timezone";
    RegularOperator["TZ"] = "tz";
    // Hash functions
    // https://www.w3.org/TR/sparql11-query/#func-hash
    RegularOperator["MD5"] = "md5";
    RegularOperator["SHA1"] = "sha1";
    RegularOperator["SHA256"] = "sha256";
    RegularOperator["SHA384"] = "sha384";
    RegularOperator["SHA512"] = "sha512";
    // XPath Constructor functions
    // https://www.w3.org/TR/sparql11-query/#FunctionMapping
    // See Named Operators
})(RegularOperator = exports.RegularOperator || (exports.RegularOperator = {}));
var SpecialOperator;
(function (SpecialOperator) {
    // Functional Forms
    // https://www.w3.org/TR/sparql11-query/#func-forms
    SpecialOperator["BOUND"] = "bound";
    SpecialOperator["IF"] = "if";
    SpecialOperator["COALESCE"] = "coalesce";
    // EXISTENCE = 'existence',
    SpecialOperator["LOGICAL_OR"] = "||";
    SpecialOperator["LOGICAL_AND"] = "&&";
    // EQUAL = '=', // See RegularOperators
    SpecialOperator["SAME_TERM"] = "sameterm";
    SpecialOperator["IN"] = "in";
    SpecialOperator["NOT_IN"] = "notin";
    // Annoying functions
    SpecialOperator["CONCAT"] = "concat";
    // Context dependant functions
    SpecialOperator["NOW"] = "now";
    SpecialOperator["IRI"] = "iri";
    SpecialOperator["URI"] = "uri";
    SpecialOperator["BNODE"] = "BNODE";
})(SpecialOperator = exports.SpecialOperator || (exports.SpecialOperator = {}));
exports.RegularOperators = immutable_1.Set(Object.values(RegularOperator));
exports.SpecialOperators = immutable_1.Set(Object.values(SpecialOperator));
exports.Operators = exports.RegularOperators.union(exports.SpecialOperators);
var SetFunction;
(function (SetFunction) {
    SetFunction["COUNT"] = "count";
    SetFunction["SUM"] = "sum";
    SetFunction["MIN"] = "min";
    SetFunction["MAX"] = "max";
    SetFunction["AVG"] = "avg";
    SetFunction["GROUP_CONCAT"] = "group_concat";
    SetFunction["SAMPLE"] = "sample";
})(SetFunction = exports.SetFunction || (exports.SetFunction = {}));
exports.SetFunctions = immutable_1.Set(Object.values(SetFunction));
exports.NamedOperators = immutable_1.Set([
    TypeURL.XSD_STRING,
    TypeURL.XSD_FLOAT,
    TypeURL.XSD_DOUBLE,
    TypeURL.XSD_DECIMAL,
    TypeURL.XSD_INTEGER,
    TypeURL.XSD_DATE_TIME,
    TypeURL.XSD_BOOLEAN,
]);
//# sourceMappingURL=Consts.js.map