/**
 * TODO: Fix decently
 * Parses float datatypes (double, float).
 *
 * All invalid lexical values return undefined.
 *
 * @param value the string to interpret as a number
 */
export declare function parseXSDFloat(value: string): number | undefined;
/**
 * Parses decimal datatypes (decimal, int, byte, nonPositiveInteger, etc...).
 *
 * All other values, including NaN, INF, and floating point numbers all
 * return undefined;
 *
 * @param value the string to interpret as a number
 */
export declare function parseXSDDecimal(value: string): number | undefined;
/**
 * Parses integer datatypes (decimal, int, byte, nonPositiveInteger, etc...).
 *
 * All other values, including NaN, INF, and floating point numbers all
 * return undefined;
 *
 * @param value the string to interpret as a number
 */
export declare function parseXSDInteger(value: string): number | undefined;
export interface SplittedDate {
    year: string;
    month: string;
    day: string;
    hours: string;
    minutes: string;
    seconds: string;
    timezone: string;
}
/**
 * Parses ISO date time strings into it's parts.
 * I found no lib providing this functionality online, but it's needed heavily
 * by the spec (functions on dates), using any form of JS DateTime will lose the
 * original timezone notation.
 *
 * Example strings:
 *  - "2011-01-10T14:45:13.815-05:00"
 *  - "2011-01-10T14:45:13.815Z"
 *  - "2011-01-10T14:45:13Z"
 * @param value the ISO date time string
 */
export declare function parseXSDDateTime(value: string): SplittedDate;
