"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stream_1 = require("stream");
/**
 * Transforms a stream of SPARQL JSON bindings object to parsed bindings.
 */
class SparqlJsonBindingsTransformer extends stream_1.Transform {
    constructor(parser) {
        super({ objectMode: true });
        this.parser = parser;
    }
    _transform(chunk, encoding, callback) {
        callback(null, this.parser.parseJsonBindings(chunk));
    }
}
exports.SparqlJsonBindingsTransformer = SparqlJsonBindingsTransformer;
//# sourceMappingURL=SparqlJsonBindingsTransformer.js.map