"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stream_1 = require("stream");
/**
 * Transforms a stream of SPARQL JSON bindings object to parsed bindings.
 */
class SparqlXmlBindingsTransformer extends stream_1.Transform {
    constructor(parser) {
        super({ objectMode: true });
        this.parser = parser;
    }
    _transform(chunk, encoding, callback) {
        let bindings;
        try {
            bindings = this.parser.parseXmlBindings(chunk);
        }
        catch (e) {
            return callback(e);
        }
        callback(null, bindings);
    }
}
exports.SparqlXmlBindingsTransformer = SparqlXmlBindingsTransformer;
//# sourceMappingURL=SparqlXmlBindingsTransformer.js.map