#!/usr/bin/env node
/*
 * Copyright (c) 2015 Dickson Tam
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */

var logger = require('../common/logger.js');

var program = require('commander')
  .usage('<[hostname][:port]> [options]')
  .version('0.0.1')
  .parse(process.argv);

if (!program.args[0]) {
  console.log('ERROR! Hostname and/or port is required.');
  program.help();
}

var location = program.args[0].split(':');


var http = require('http');
var proxyHost = location[0] || 'localhost';
var proxyPort = location[1] || 5050;
var path = '/spectral/screen';

logger('spectral').log('Connecting to ' + proxyHost + ':' + proxyPort);

http.get({
    hostname: proxyHost,
    port: proxyPort,
    path: path,
  }, function(res) {
    logger('client').log(res);
  }).on('error', function(err) {
    logger('spectral').log('Failed to connect to ' + proxyHost + ':' + proxyPort);
    logger('spectral').log(err.message);
  });
