/// <reference types="node" />
import { AzureOptions, Options } from '../../types/options';
import * as sdk from 'microsoft-cognitiveservices-speech-sdk';
import { Speech } from '../../speech';
declare global {
    interface Window {
        SpeechSDK: typeof sdk;
    }
}
export declare class Azure extends Speech {
    private _stopping?;
    private _service?;
    private _translations?;
    private _retrieveTokenInterval?;
    _manualConnectionStopPrevention?: NodeJS.Timeout;
    private _newTextPadding;
    start(options: Options & AzureOptions, isDuringReset?: boolean): void;
    private startAsync;
    private validate;
    private instantiateService;
    private setEvents;
    private onRecognizing;
    private onRecognized;
    private onCanceled;
    private onSessionStarted;
    private onSessionStopped;
    private retrieveTokenInterval;
    stop(isDuringReset?: boolean): void;
    static getAPI(): typeof sdk;
    private moduleNotFound;
    private error;
}
