(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react'], factory) :
  (global = global || self, factory(global.spinDelay = {}, global.react));
}(this, (function (exports, react) {
  const defaultOptions = {
    delay: 500,
    minDuration: 200,
    ssr: true
  };

  function useIsSSR() {
    const [isSSR, setIsSSR] = react.useState(true);
    react.useEffect(() => {
      setIsSSR(false);
    }, []);
    return isSSR;
  }

  function useSpinDelay(loading, options) {
    options = Object.assign({}, defaultOptions, options);
    const isSSR = useIsSSR() && options.ssr;
    const initialState = isSSR && loading ? 'DISPLAY' : 'IDLE';
    const [state, setState] = react.useState(initialState);
    const timeout = react.useRef(null);
    react.useEffect(() => {
      if (loading && (state === 'IDLE' || isSSR)) {
        clearTimeout(timeout.current);
        const delay = isSSR ? 0 : options.delay;
        timeout.current = setTimeout(() => {
          if (!loading) {
            return setState('IDLE');
          }

          timeout.current = setTimeout(() => {
            setState('EXPIRE');
          }, options.minDuration);
          setState('DISPLAY');
        }, delay);

        if (!isSSR) {
          setState('DELAY');
        }
      }

      if (!loading && state !== 'DISPLAY') {
        clearTimeout(timeout.current);
        setState('IDLE');
      }
    }, [loading, state, options.delay, options.minDuration, isSSR]);
    react.useEffect(() => {
      return () => clearTimeout(timeout.current);
    }, []);
    return state === 'DISPLAY' || state === 'EXPIRE';
  }

  exports.defaultOptions = defaultOptions;
  exports.useSpinDelay = useSpinDelay;

})));
//# sourceMappingURL=index.js.map
