import _regeneratorRuntime from 'babel-runtime/regenerator';
import _asyncToGenerator from 'babel-runtime/helpers/asyncToGenerator';
import _Object$create from 'babel-runtime/core-js/object/create';
import _Object$assign from 'babel-runtime/core-js/object/assign';
import ClientFactory from '../client';
import OfflineProducerFactory from '../producer/offline';
import { releaseApiKey } from '../utils/inputValidation';

//
// Create SDK instance for offline mode.
//
function SplitFactoryOffline(context, sharedTrackers) {
  var sharedInstance = !sharedTrackers;
  var readiness = context.get(context.constants.READINESS);
  var storage = context.get(context.constants.STORAGE);
  var statusManager = context.get(context.constants.STATUS_MANAGER);

  // Producer
  var producer = sharedInstance ? undefined : OfflineProducerFactory(context);

  // Start background task for flag updates
  producer && producer.start();

  var api = _Object$assign(
  // Proto linkage of the EventEmitter to prevent any change
  _Object$create(statusManager),
  // GetTreatment/s
  ClientFactory(context),
  // Utilities
  {
    // Destroy instance. Async so we respect the online api.
    destroy: function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                // Stop background jobs
                producer && producer.stop();
                // Cleanup event listeners
                readiness.destroy();
                // Cleanup storage
                storage.destroy && storage.destroy();
                // Mark the factory as destroyed.
                context.put(context.constants.DESTROYED, true);
                !sharedInstance && releaseApiKey();

              case 5:
              case 'end':
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function destroy() {
        return _ref.apply(this, arguments);
      }

      return destroy;
    }()
  });

  return {
    api: api,
    metricCollectors: false // We won't collect any metrics on localhost mode.
  };
}

export default SplitFactoryOffline;