import _regeneratorRuntime from 'babel-runtime/regenerator';
import _Promise from 'babel-runtime/core-js/promise';
import _asyncToGenerator from 'babel-runtime/helpers/asyncToGenerator';
import _Object$create from 'babel-runtime/core-js/object/create';
import _Object$assign from 'babel-runtime/core-js/object/assign';
import ClientFactory from '../client';
import FullProducerFactory from '../producer';
import PartialProducerFactory from '../producer/browser/Partial';
import MetricsFactory from '../metrics';
import EventsFactory from '../events';
import SignalsListener from '../listeners';
import { STANDALONE_MODE, PRODUCER_MODE, CONSUMER_MODE } from '../utils/constants';
import { releaseApiKey } from '../utils/inputValidation';

//
// Create SDK instance based on the provided configurations
//
function SplitFactoryOnline(context, readyTrackers, mainClientMetricCollectors) {
  var sharedInstance = !!mainClientMetricCollectors;
  var settings = context.get(context.constants.SETTINGS);
  var readiness = context.get(context.constants.READINESS);
  var storage = context.get(context.constants.STORAGE);
  var statusManager = context.get(context.constants.STATUS_MANAGER);

  // We are only interested in exposable EventEmitter
  var gate = readiness.gate,
      splits = readiness.splits,
      segments = readiness.segments;

  // Events name

  var SDK_READY = gate.SDK_READY;

  // Shared instances use parent metrics collectors

  var metrics = sharedInstance ? undefined : MetricsFactory(context);
  // Shared instances use parent events queue
  var events = sharedInstance ? undefined : EventsFactory(context);
  // Signal listener only needed for main instances
  var signalsListener = sharedInstance ? undefined : new SignalsListener(context);

  var producer = void 0;

  switch (settings.mode) {
    case PRODUCER_MODE:
    case STANDALONE_MODE:
      {
        context.put(context.constants.COLLECTORS, metrics && metrics.collectors);
        // We don't fully instantiate producer if we are creating a shared instance.
        producer = sharedInstance ? PartialProducerFactory(context) : FullProducerFactory(context);
        break;
      }
    case CONSUMER_MODE:
      {
        context.put(context.constants.READY, true); // For SDK inner workings it's supposed to be ready.
        setTimeout(function () {
          // Allow for the sync statements to run so client is returned before these are emitted and callbacks executed.
          splits.emit(splits.SDK_SPLITS_ARRIVED, false);
          segments.emit(segments.SDK_SEGMENTS_ARRIVED, false);
        }, 0);
        break;
      }
  }

  if (readyTrackers && producer && !sharedInstance) {
    // Only track ready events for non-shared and non-consumer clients
    var sdkReadyTracker = readyTrackers.sdkReadyTracker,
        splitsReadyTracker = readyTrackers.splitsReadyTracker,
        segmentsReadyTracker = readyTrackers.segmentsReadyTracker;

    // Defered setup of collectors for this task, as it is the only ready latency we store on BE.

    sdkReadyTracker.setCollectorForTask(metrics.collectors);

    gate.on(SDK_READY, sdkReadyTracker);
    splits.once(splits.SDK_SPLITS_ARRIVED, splitsReadyTracker);
    segments.once(segments.SDK_SEGMENTS_ARRIVED, segmentsReadyTracker);
  }

  // Start background jobs tasks
  producer && producer.start();
  metrics && metrics.start();
  events && context.put(context.constants.EVENTS, events) && events.start();

  // If no collectors are stored we are on a shared instance, save main one.
  context.put(context.constants.COLLECTORS, mainClientMetricCollectors);

  var api = _Object$assign(
  // Proto linkage of the EventEmitter to prevent any change
  _Object$create(statusManager),
  // getTreatment/s & track
  ClientFactory(context),
  // Utilities
  {
    // Destroy instance
    destroy: function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                // Stop background jobs
                producer && producer.stop();
                metrics && metrics.stop();
                events && events.stop();

                // Send impressions and events in parallel.
                _context.next = 5;
                return _Promise.all([metrics && metrics.flush(), events && events.flush()]);

              case 5:

                // Cleanup event listeners
                readiness.destroy();
                signalsListener && signalsListener.stop();

                // Cleanup storage
                storage.destroy && storage.destroy();
                // Mark the factory as destroyed.
                context.put(context.constants.DESTROYED, true);
                // And release the API Key
                !sharedInstance && releaseApiKey(settings.core.authorizationKey);

              case 10:
              case 'end':
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function destroy() {
        return _ref.apply(this, arguments);
      }

      return destroy;
    }()
  });

  // We'll start the signals listener if the client is not a shared instance.
  // For now, we will only call destroy.
  !sharedInstance && signalsListener.start(api.destroy);

  return {
    api: api,
    metricCollectors: metrics && metrics.collectors
  };
}

export default SplitFactoryOnline;