import _Object$getPrototypeOf from 'babel-runtime/core-js/object/get-prototype-of';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';

var ProducerMetricsCollector = function () {
  function ProducerMetricsCollector(storage) {
    _classCallCheck(this, ProducerMetricsCollector);

    this.storage = storage;

    this.latency = this.latency.bind(this);
    this.count = this.count.bind(this);
    this.countException = this.countException.bind(this);
  }

  _createClass(ProducerMetricsCollector, [{
    key: 'latency',
    value: function latency(ms) {
      this.storage.metrics.track(this.metricType + '.time', ms);
    }
  }, {
    key: 'count',
    value: function count(status) {
      this.storage.count.track(this.metricType + '.status.' + status);
    }
  }, {
    key: 'countException',
    value: function countException() {
      this.storage.count.track(this.metricType + '.exception');
    }
  }]);

  return ProducerMetricsCollector;
}();

export var SegmentChangesCollector = function (_ProducerMetricsColle) {
  _inherits(SegmentChangesCollector, _ProducerMetricsColle);

  function SegmentChangesCollector(storage) {
    _classCallCheck(this, SegmentChangesCollector);

    var _this = _possibleConstructorReturn(this, (SegmentChangesCollector.__proto__ || _Object$getPrototypeOf(SegmentChangesCollector)).call(this, storage));

    _this.metricType = 'segmentChangeFetcher';
    return _this;
  }

  return SegmentChangesCollector;
}(ProducerMetricsCollector);

export var SplitChangesCollector = function (_ProducerMetricsColle2) {
  _inherits(SplitChangesCollector, _ProducerMetricsColle2);

  function SplitChangesCollector(storage) {
    _classCallCheck(this, SplitChangesCollector);

    var _this2 = _possibleConstructorReturn(this, (SplitChangesCollector.__proto__ || _Object$getPrototypeOf(SplitChangesCollector)).call(this, storage));

    _this2.metricType = 'splitChangeFetcher';
    return _this2;
  }

  return SplitChangesCollector;
}(ProducerMetricsCollector);

export var MySegmentsCollector = function (_ProducerMetricsColle3) {
  _inherits(MySegmentsCollector, _ProducerMetricsColle3);

  function MySegmentsCollector(storage) {
    _classCallCheck(this, MySegmentsCollector);

    var _this3 = _possibleConstructorReturn(this, (MySegmentsCollector.__proto__ || _Object$getPrototypeOf(MySegmentsCollector)).call(this, storage));

    _this3.metricType = 'mySegmentsFetcher';
    return _this3;
  }

  return MySegmentsCollector;
}(ProducerMetricsCollector);

export var ClientCollector = function () {
  function ClientCollector(storage) {
    _classCallCheck(this, ClientCollector);

    this.storage = storage;

    this.ready = this.ready.bind(this);
    this.getTreatment = this.getTreatment.bind(this);
    this.getTreatments = this.getTreatments.bind(this);
    this.getTreatmentWithConfig = this.getTreatmentWithConfig.bind(this);
    this.getTreatmentsWithConfig = this.getTreatmentsWithConfig.bind(this);
  }

  _createClass(ClientCollector, [{
    key: 'ready',
    value: function ready(ms) {
      this.storage.metrics.track('sdk.ready', ms);
    }
  }, {
    key: 'getTreatment',
    value: function getTreatment(ms) {
      this.storage.metrics.track('sdk.getTreatment', ms);
    }
  }, {
    key: 'getTreatments',
    value: function getTreatments(ms) {
      this.storage.metrics.track('sdk.getTreatments', ms);
    }
  }, {
    key: 'getTreatmentWithConfig',
    value: function getTreatmentWithConfig(ms) {
      this.storage.metrics.track('sdk.getTreatmentWithConfig', ms);
    }
  }, {
    key: 'getTreatmentsWithConfig',
    value: function getTreatmentsWithConfig(ms) {
      this.storage.metrics.track('sdk.getTreatmentsWithConfig', ms);
    }
  }]);

  return ClientCollector;
}();