/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

import TaskFactory from '../task';
import MySegmentsUpdater from '../updater/MySegments';
import onSplitsArrivedFactory from './onSplitsArrivedFactory';

/**
 * Incremental updater to be used to share data in the browser.
 */
var PartialBrowserProducer = function PartialBrowserProducer(context) {
  var settings = context.get(context.constants.SETTINGS);

  var _context$get = context.get(context.constants.READINESS),
      splitsEventEmitter = _context$get.splits;

  var segmentsUpdater = MySegmentsUpdater(context);
  var segmentsUpdaterTask = TaskFactory(segmentsUpdater, settings.scheduler.segmentsRefreshRate);

  var onSplitsArrived = onSplitsArrivedFactory(segmentsUpdaterTask, context);

  splitsEventEmitter.on(splitsEventEmitter.SDK_SPLITS_ARRIVED, onSplitsArrived);

  return segmentsUpdaterTask;
};

export default PartialBrowserProducer;