import logFactory from '../../utils/logger';
var log = logFactory('splitio-producer:mySegmentsHandler');

export default function onSplitsArrivedCtx(segmentsUpdaterTask, context) {
  var syncingSegments = true;
  var splitsStorage = context.get(context.constants.STORAGE).splits;

  var _context$get = context.get(context.constants.READINESS),
      segmentsEventEmitter = _context$get.segments;

  return function onSplitsArrived() {
    var splitsHaveSegments = splitsStorage.usesSegments();

    if (splitsHaveSegments !== syncingSegments) {
      syncingSegments = splitsHaveSegments;
      log.info('Turning segments data polling ' + (splitsHaveSegments ? 'ON' : 'OFF') + '.');

      if (splitsHaveSegments) {
        segmentsUpdaterTask.start();
      } else {
        var isReady = context.get(context.constants.READY, true);

        if (!isReady) segmentsEventEmitter.emit(segmentsEventEmitter.SDK_SEGMENTS_ARRIVED);
        segmentsUpdaterTask.stop();
      }
    }
  };
}