import _regeneratorRuntime from 'babel-runtime/regenerator';
import _getIterator from 'babel-runtime/core-js/get-iterator';
import _Promise from 'babel-runtime/core-js/promise';
import _asyncToGenerator from 'babel-runtime/helpers/asyncToGenerator';
/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

import logFactory from '../../utils/logger';
var log = logFactory('splitio-producer:segment-changes');
var inputValidationLog = logFactory('', { displayAllErrors: true });
import segmentChangesFetcher from '../fetcher/SegmentChanges';
import { findIndex, startsWith } from '../../utils/lang';
import { SplitError } from '../../utils/lang/Errors';

var SegmentChangesUpdaterFactory = function SegmentChangesUpdaterFactory(context) {
  var _context$getAll = context.getAll(),
      settings = _context$getAll[context.constants.SETTINGS],
      readiness = _context$getAll[context.constants.READINESS],
      storage = _context$getAll[context.constants.STORAGE],
      metricCollectors = _context$getAll[context.constants.COLLECTORS];

  var segmentsEventEmitter = readiness.segments;

  var readyOnAlreadyExistentState = true;

  return function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
      var _this = this;

      var updaters, segments, _loop, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, segmentName;

      return _regeneratorRuntime.wrap(function _callee2$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              log.debug('Started segments update');

              // Async fetchers are collected here.
              updaters = [];

              // Read list of available segments names to be updated.

              _context3.next = 4;
              return storage.segments.getRegisteredSegments();

            case 4:
              segments = _context3.sent;
              _loop = /*#__PURE__*/_regeneratorRuntime.mark(function _loop(segmentName) {
                var since;
                return _regeneratorRuntime.wrap(function _loop$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        _context2.next = 2;
                        return storage.segments.getChangeNumber(segmentName);

                      case 2:
                        since = _context2.sent;


                        log.debug('Processing segment ' + segmentName);

                        updaters.push(segmentChangesFetcher(settings, segmentName, since, metricCollectors).then(function () {
                          var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(changes) {
                            var changeNumber, _iteratorNormalCompletion2, _didIteratorError2, _iteratorError2, _iterator2, _step2, x;

                            return _regeneratorRuntime.wrap(function _callee$(_context) {
                              while (1) {
                                switch (_context.prev = _context.next) {
                                  case 0:
                                    changeNumber = -1;
                                    _iteratorNormalCompletion2 = true;
                                    _didIteratorError2 = false;
                                    _iteratorError2 = undefined;
                                    _context.prev = 4;
                                    _iterator2 = _getIterator(changes);

                                  case 6:
                                    if (_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done) {
                                      _context.next = 22;
                                      break;
                                    }

                                    x = _step2.value;

                                    if (!(x.added.length > 0)) {
                                      _context.next = 11;
                                      break;
                                    }

                                    _context.next = 11;
                                    return storage.segments.addToSegment(segmentName, x.added);

                                  case 11:
                                    if (!(x.removed.length > 0)) {
                                      _context.next = 14;
                                      break;
                                    }

                                    _context.next = 14;
                                    return storage.segments.removeFromSegment(segmentName, x.removed);

                                  case 14:
                                    if (!(x.added.length > 0 || x.removed.length > 0)) {
                                      _context.next = 18;
                                      break;
                                    }

                                    _context.next = 17;
                                    return storage.segments.setChangeNumber(segmentName, x.till);

                                  case 17:
                                    changeNumber = x.till;

                                  case 18:

                                    log.debug('Processed ' + segmentName + ' with till = ' + x.till + '. Added: ' + x.added.length + '. Removed: ' + x.removed.length);

                                  case 19:
                                    _iteratorNormalCompletion2 = true;
                                    _context.next = 6;
                                    break;

                                  case 22:
                                    _context.next = 28;
                                    break;

                                  case 24:
                                    _context.prev = 24;
                                    _context.t0 = _context['catch'](4);
                                    _didIteratorError2 = true;
                                    _iteratorError2 = _context.t0;

                                  case 28:
                                    _context.prev = 28;
                                    _context.prev = 29;

                                    if (!_iteratorNormalCompletion2 && _iterator2.return) {
                                      _iterator2.return();
                                    }

                                  case 31:
                                    _context.prev = 31;

                                    if (!_didIteratorError2) {
                                      _context.next = 34;
                                      break;
                                    }

                                    throw _iteratorError2;

                                  case 34:
                                    return _context.finish(31);

                                  case 35:
                                    return _context.finish(28);

                                  case 36:
                                    return _context.abrupt('return', changeNumber);

                                  case 37:
                                  case 'end':
                                    return _context.stop();
                                }
                              }
                            }, _callee, this, [[4, 24, 28, 36], [29,, 31, 35]]);
                          }));

                          return function (_x) {
                            return _ref2.apply(this, arguments);
                          };
                        }()));

                      case 5:
                      case 'end':
                        return _context2.stop();
                    }
                  }
                }, _loop, _this);
              });
              _iteratorNormalCompletion = true;
              _didIteratorError = false;
              _iteratorError = undefined;
              _context3.prev = 9;
              _iterator = _getIterator(segments);

            case 11:
              if (_iteratorNormalCompletion = (_step = _iterator.next()).done) {
                _context3.next = 17;
                break;
              }

              segmentName = _step.value;
              return _context3.delegateYield(_loop(segmentName), 't0', 14);

            case 14:
              _iteratorNormalCompletion = true;
              _context3.next = 11;
              break;

            case 17:
              _context3.next = 23;
              break;

            case 19:
              _context3.prev = 19;
              _context3.t1 = _context3['catch'](9);
              _didIteratorError = true;
              _iteratorError = _context3.t1;

            case 23:
              _context3.prev = 23;
              _context3.prev = 24;

              if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
              }

            case 26:
              _context3.prev = 26;

              if (!_didIteratorError) {
                _context3.next = 29;
                break;
              }

              throw _iteratorError;

            case 29:
              return _context3.finish(26);

            case 30:
              return _context3.finish(23);

            case 31:
              return _context3.abrupt('return', _Promise.all(updaters).then(function (shouldUpdateFlags) {
                if (findIndex(shouldUpdateFlags, function (v) {
                  return v !== -1;
                }) !== -1 || readyOnAlreadyExistentState) {
                  readyOnAlreadyExistentState = false;
                  segmentsEventEmitter.emit(segmentsEventEmitter.SDK_SEGMENTS_ARRIVED);
                }
              }).catch(function (error) {
                if (!(error instanceof SplitError)) setTimeout(function () {
                  throw error;
                }, 0);

                if (startsWith(error.message, '403')) {
                  context.put(context.constants.DESTROYED, true);
                  inputValidationLog.error('Factory instantiation: you passed a Browser type authorizationKey, please grab an Api Key from the Split web console that is of type SDK.');
                }
              }));

            case 32:
            case 'end':
              return _context3.stop();
          }
        }
      }, _callee2, this, [[9, 19, 23, 31], [24,, 26, 30]]);
    }));

    function SegmentChangesUpdater() {
      return _ref.apply(this, arguments);
    }

    return SegmentChangesUpdater;
  }();
};

export default SegmentChangesUpdaterFactory;