import _regeneratorRuntime from 'babel-runtime/regenerator';
import _Promise from 'babel-runtime/core-js/promise';
import _asyncToGenerator from 'babel-runtime/helpers/asyncToGenerator';
import _toConsumableArray from 'babel-runtime/helpers/toConsumableArray';
import _Set from 'babel-runtime/core-js/set';
import _getIterator from 'babel-runtime/core-js/get-iterator';
import _JSON$stringify from 'babel-runtime/core-js/json/stringify';
/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

import logFactory from '../../utils/logger';
var log = logFactory('splitio-producer:split-changes');
import splitChangesFetcher from '../fetcher/SplitChanges';
import parseSegments from '../../engine/parser/segments';
import { SplitError } from '../../utils/lang/Errors';

function computeSplitsMutation(entries) {
  var computed = entries.reduce(function (accum, split) {
    if (split.status === 'ACTIVE') {
      accum.added.push([split.name, _JSON$stringify(split)]);

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = _getIterator(parseSegments(split.conditions)), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var segmentName = _step.value;

          accum.segments.add(segmentName);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    } else {
      accum.removed.push(split.name);
    }

    return accum;
  }, {
    added: [],
    removed: [],
    segments: new _Set()
  });

  computed.segments = [].concat(_toConsumableArray(computed.segments));

  return computed;
}

function SplitChangesUpdaterFactory(context) {
  var isNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  var _context$getAll = context.getAll(),
      settings = _context$getAll[context.constants.SETTINGS],
      readiness = _context$getAll[context.constants.READINESS],
      storage = _context$getAll[context.constants.STORAGE],
      metricCollectors = _context$getAll[context.constants.COLLECTORS];

  var splitsEventEmitter = readiness.splits;

  var startingUp = true;
  var readyOnAlreadyExistentState = true;

  return function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var retry = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var since;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return storage.splits.getChangeNumber();

            case 2:
              since = _context.sent;


              log.debug('Spin up split update using since = ' + since);

              return _context.abrupt('return', splitChangesFetcher(settings, since, startingUp, metricCollectors, isNode).then(function (splitChanges) {
                startingUp = false;

                var mutation = computeSplitsMutation(splitChanges.splits);

                log.debug('New splits ' + mutation.added.length);
                log.debug('Removed splits ' + mutation.removed.length);
                log.debug('Segment names collected ' + mutation.segments);

                // Write into storage
                return _Promise.all([storage.splits.addSplits(mutation.added), storage.splits.removeSplits(mutation.removed), storage.splits.setChangeNumber(splitChanges.till), storage.segments.registerSegments(mutation.segments)]).then(function () {
                  if (since !== splitChanges.till || readyOnAlreadyExistentState) {
                    readyOnAlreadyExistentState = false;
                    splitsEventEmitter.emit(splitsEventEmitter.SDK_SPLITS_ARRIVED);
                  }
                });
              }).catch(function (error) {
                if (!(error instanceof SplitError)) {
                  setTimeout(function () {
                    throw error;
                  }, 0);
                  startingUp = false; // Stop retrying.
                }

                log.warn('Error while doing fetch of Splits ' + error);

                if (startingUp && settings.startup.retriesOnFailureBeforeReady > retry) {
                  retry += 1;
                  log.info('Retrying download of splits #' + retry + '. Reason: ' + error);
                  return SplitChangesUpdater(retry);
                } else {
                  startingUp = false;
                }

                return false;
              }));

            case 5:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function SplitChangesUpdater() {
      return _ref.apply(this, arguments);
    }

    return SplitChangesUpdater;
  }();
}

export default SplitChangesUpdaterFactory;