import _regeneratorRuntime from 'babel-runtime/regenerator';
import _JSON$stringify from 'babel-runtime/core-js/json/stringify';
import _asyncToGenerator from 'babel-runtime/helpers/asyncToGenerator';
/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/
import { forOwn } from '../../utils/lang';
import logFactory from '../../utils/logger';
var log = logFactory('splitio-producer:offline');

function FromObjectUpdaterFactory(Fetcher, context) {
  var _context$getAll = context.getAll(),
      settings = _context$getAll[context.constants.SETTINGS],
      readiness = _context$getAll[context.constants.READINESS],
      storage = _context$getAll[context.constants.STORAGE];

  return function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var splits, loadError, splitsMock;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              splits = [];
              loadError = null;
              splitsMock = {};

              try {
                splitsMock = Fetcher(settings);
              } catch (err) {
                loadError = err;
                log.error('There was an issue loading the mock Splits data, no changes will be applied to the current cache. ' + err);
              }

              if (loadError) {
                _context.next = 14;
                break;
              }

              log.debug('Splits data:');
              log.debug(_JSON$stringify(splitsMock));

              forOwn(splitsMock, function (val, name) {
                splits.push([name, _JSON$stringify({
                  name: name,
                  status: 'ACTIVE',
                  killed: false,
                  trafficAllocation: 100,
                  defaultTreatment: 'control',
                  conditions: val.conditions || [],
                  configurations: val.configurations,
                  trafficTypeName: val.trafficTypeName
                })]);
              });

              _context.next = 10;
              return storage.splits.flush();

            case 10:
              _context.next = 12;
              return storage.splits.addSplits(splits);

            case 12:

              readiness.splits.emit(readiness.splits.SDK_SPLITS_ARRIVED);
              readiness.segments.emit(readiness.segments.SDK_SEGMENTS_ARRIVED);

            case 14:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function ObjectUpdater() {
      return _ref.apply(this, arguments);
    }

    return ObjectUpdater;
  }();
}

export default FromObjectUpdaterFactory;