import _Object$create from 'babel-runtime/core-js/object/create';
import _Object$assign from 'babel-runtime/core-js/object/assign';
import _Promise from 'babel-runtime/core-js/promise';
import logFactory from '../utils/logger';
var log = logFactory('', { displayAllErrors: true });

var NEW_LISTENER_EVENT = 'newListener';
var REMOVE_LISTENER_EVENT = 'removeListener';

export default function callbackHandlerContext(context) {
  var forSharedClient = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  var gate = context.get(context.constants.READINESS).gate;
  var readyCbCount = 0;
  var isReady = false;
  var SDK_READY = gate.SDK_READY,
      SDK_UPDATE = gate.SDK_UPDATE,
      SDK_READY_TIMED_OUT = gate.SDK_READY_TIMED_OUT;

  var readyPromise = getReadyPromise();

  gate.once(SDK_READY, function () {
    if (readyCbCount === 0) log.warn('No listeners for SDK Readiness detected. Incorrect control treatments could have been logged if you called getTreatment/s while the SDK was not yet ready.');

    context.put(context.constants.READY, true);

    isReady = true;
  });

  gate.on(REMOVE_LISTENER_EVENT, function (event) {
    if (event === SDK_READY) readyCbCount--;
  });

  gate.on(NEW_LISTENER_EVENT, function (event) {
    if (event === SDK_READY || event === SDK_READY_TIMED_OUT) {
      if (isReady) {
        log.error('A listener was added for ' + (event === SDK_READY ? 'SDK_READY' : 'SDK_READY_TIMED_OUT') + ' on the SDK, which has already fired and won\'t be emitted again. The callback won\'t be executed.');
      } else if (event === SDK_READY) {
        readyCbCount++;
      }
    }
  });

  function generateReadyPromise() {
    var hasCatch = false;
    var promise = new _Promise(function (resolve, reject) {
      gate.once(SDK_READY, resolve);
      gate.once(SDK_READY_TIMED_OUT, reject);
    }).catch(function (err) {
      // If the promise has a custom error handler, just propagate
      if (hasCatch) throw err;
      // If not handle the error to prevent unhandled promise exception.
      log.error(err);
    });
    var originalThen = promise.then;

    // Using .catch(fn) is the same than using .then(null, fn)
    promise.then = function () {
      if (arguments.length > 0 && typeof arguments[0] === 'function') readyCbCount++;
      if (arguments.length > 1 && typeof arguments[1] === 'function') hasCatch = true;

      return originalThen.apply(this, arguments);
    };

    return promise;
  }

  function getReadyPromise() {
    if (forSharedClient) {
      return _Promise.resolve();
    }

    // Non-shared clients use the full blown ready promise implementation.
    return generateReadyPromise();
  }

  return _Object$assign(
  // Expose Event Emitter functionality
  _Object$create(gate), {
    // Expose the event constants without changing the interface
    Event: {
      SDK_READY: SDK_READY,
      SDK_UPDATE: SDK_UPDATE,
      SDK_READY_TIMED_OUT: SDK_READY_TIMED_OUT
    },
    // Expose the ready promise flag
    ready: function ready() {
      return readyPromise;
    }
  });
}