/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/
import { forOwn } from '../../utils/lang';

export function fromLatenciesCollector(latenciesCollector) {
  var result = [];
  var metrics = latenciesCollector.toJSON();

  forOwn(metrics, function (latencies, key) {
    result.push({
      name: key,
      latencies: latencies
    });
  });

  return result;
}

export function fromCountersCollector(countersCollector) {
  var result = [];
  var metrics = countersCollector.toJSON();

  forOwn(metrics, function (delta, key) {
    result.push({
      name: key,
      delta: delta
    });
  });

  return result;
}