import { isObject, forOwn } from '../../../utils/lang';
import parseCondition from './parseCondition';

function getConfigurationFromSettings(settings) {
  var mockSettings = settings.features || {};
  var splitObjects = {};

  forOwn(mockSettings, function (data, splitName) {
    var treatment = data;
    var config = null;

    if (isObject(data)) {
      treatment = data.treatment;
      config = data.config || config;
    }
    var configurations = {};
    if (config !== null) configurations[treatment] = config;

    splitObjects[splitName] = {
      conditions: [parseCondition({ treatment: treatment })],
      configurations: configurations
    };
  });

  return splitObjects;
}

export default getConfigurationFromSettings;