import _JSON$stringify from 'babel-runtime/core-js/json/stringify';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/
import logFactory from '../../utils/logger';
var log = logFactory('splitio-storage:redis');

var EventsCache = function () {
  function EventsCache(keys, redis, meta) {
    _classCallCheck(this, EventsCache);

    this.keys = keys;
    this.redis = redis;
    this.meta = meta;

    this.eventsKey = keys.buildEventsKey();
  }

  /**
   * Add a new event object into the queue.
   */


  _createClass(EventsCache, [{
    key: 'track',
    value: function track(eventData) {
      return this.redis.rpush(this.eventsKey, this._toJSON(eventData))
      // We use boolean values to signal successful queueing
      .then(function () {
        return true;
      }).catch(function (err) {
        log.error('Error adding event to queue: ' + err + '.');
        return false;
      });
    }

    /**
     * Generates the JSON as we'll store it on Redis.
     */

  }, {
    key: '_toJSON',
    value: function _toJSON(eventData) {
      return _JSON$stringify({
        m: this.meta,
        e: eventData
      });
    }

    /**
     * We are returning true because the go syncronizer push the impressions from redis.
     */

  }, {
    key: 'isEmpty',
    value: function isEmpty() {
      return true;
    }
  }]);

  return EventsCache;
}();

export default EventsCache;