import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import { startsWith } from '../utils/lang';

var everythingAtTheEnd = /[^.]+$/;
var everythingAfterCount = /count\.([^/]+)$/;
var latencyMetricNameAndBucket = /latency\.([^/]+)\.bucket\.([0-9]+)$/;

var KeyBuilder = function () {
  function KeyBuilder(settings) {
    _classCallCheck(this, KeyBuilder);

    this.settings = settings;
  }

  _createClass(KeyBuilder, [{
    key: 'buildSplitKey',
    value: function buildSplitKey(splitName) {
      return this.settings.storage.prefix + '.split.' + splitName;
    }
  }, {
    key: 'buildTrafficTypeKey',
    value: function buildTrafficTypeKey(trafficType) {
      return this.settings.storage.prefix + '.trafficType.' + trafficType;
    }
  }, {
    key: 'buildSplitsTillKey',
    value: function buildSplitsTillKey() {
      return this.settings.storage.prefix + '.splits.till';
    }
  }, {
    key: 'buildSplitsReady',
    value: function buildSplitsReady() {
      return this.settings.storage.prefix + '.splits.ready';
    }
  }, {
    key: 'isSplitKey',
    value: function isSplitKey(key) {
      return startsWith(key, this.settings.storage.prefix + '.split.');
    }
  }, {
    key: 'buildSegmentNameKey',
    value: function buildSegmentNameKey(segmentName) {
      return this.settings.storage.prefix + '.segment.' + segmentName;
    }
  }, {
    key: 'buildSegmentTillKey',
    value: function buildSegmentTillKey(segmentName) {
      return this.settings.storage.prefix + '.segment.' + segmentName + '.till';
    }
  }, {
    key: 'buildRegisteredSegmentsKey',
    value: function buildRegisteredSegmentsKey() {
      return this.settings.storage.prefix + '.segments.registered';
    }
  }, {
    key: 'buildSegmentsReady',
    value: function buildSegmentsReady() {
      return this.settings.storage.prefix + '.segments.ready';
    }
  }, {
    key: 'buildVersionablePrefix',
    value: function buildVersionablePrefix() {
      return this.settings.storage.prefix + '/' + this.settings.version + '/' + this.settings.runtime.ip;
    }
  }, {
    key: 'buildImpressionsKey',
    value: function buildImpressionsKey() {
      return this.settings.storage.prefix + '.impressions';
    }
  }, {
    key: 'buildEventsKey',
    value: function buildEventsKey() {
      return this.settings.storage.prefix + '.events';
    }
  }, {
    key: 'buildLatencyKeyPrefix',
    value: function buildLatencyKeyPrefix() {
      return this.buildVersionablePrefix() + '/latency';
    }
  }, {
    key: 'buildLatencyKey',
    value: function buildLatencyKey(metricName, bucketNumber) {
      return this.buildLatencyKeyPrefix() + '.' + metricName + '.bucket.' + bucketNumber;
    }
  }, {
    key: 'buildCountKey',
    value: function buildCountKey(metricName) {
      return this.buildVersionablePrefix() + '/count.' + metricName;
    }
  }, {
    key: 'buildGaugeKey',
    value: function buildGaugeKey(metricName) {
      return this.buildVersionablePrefix() + '/gauge.' + metricName;
    }
  }, {
    key: 'searchPatternForCountKeys',
    value: function searchPatternForCountKeys() {
      return this.buildVersionablePrefix() + '/count.*';
    }
  }, {
    key: 'searchPatternForSplitKeys',
    value: function searchPatternForSplitKeys() {
      return this.settings.storage.prefix + '.split.*';
    }
  }, {
    key: 'searchPatternForLatency',
    value: function searchPatternForLatency() {
      return this.buildLatencyKeyPrefix() + '.*';
    }
  }, {
    key: 'extractKey',
    value: function extractKey(builtKey) {
      var s = builtKey.match(everythingAtTheEnd);

      if (s && s.length) {
        return s[0];
      } else {
        throw 'Invalid latency key provided';
      }
    }
  }, {
    key: 'extractCounterName',
    value: function extractCounterName(counterKey) {
      var m = counterKey.match(everythingAfterCount);

      if (m && m.length) {
        return m[1]; // everything after count
      } else {
        throw 'Invalid counter key provided';
      }
    }
  }, {
    key: 'extractLatencyMetricNameAndBucket',
    value: function extractLatencyMetricNameAndBucket(latencyKey) {
      var parts = latencyKey.match(latencyMetricNameAndBucket);

      if (parts && parts.length > 2) {
        return {
          metricName: parts[1],
          bucketNumber: parts[2]
        };
      } else {
        throw 'Invalid counter key provided';
      }
    }
  }]);

  return KeyBuilder;
}();

export default KeyBuilder;